/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.jira.plugin.issuetabpanel.GetActionsReply;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel2;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelInvoker;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelReply;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IssueTabPanelInvokerImpl
implements IssueTabPanelInvoker {
    private static final Logger log = LoggerFactory.getLogger(IssueTabPanelInvokerImpl.class);
    private final I18nHelper.BeanFactory i18Factory;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public IssueTabPanelInvokerImpl(I18nHelper.BeanFactory i18Factory, JiraAuthenticationContext jiraAuthenticationContext) {
        this.i18Factory = i18Factory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShowPanelReply invokeShowPanel(ShowPanelRequest request, IssueTabPanel issueTabPanel) {
        String timerName = "Calling showPanel in" + issueTabPanel.getClass();
        UtilTimerStack.push((String)timerName);
        try {
            if (issueTabPanel instanceof IssueTabPanel2) {
                ShowPanelReply showPanelReply = ((IssueTabPanel2)issueTabPanel).showPanel(request);
                return showPanelReply;
            }
            ShowPanelReply showPanelReply = ShowPanelReply.create((boolean)issueTabPanel.showPanel(request.issue(), request.remoteUser()));
            return showPanelReply;
        }
        catch (RuntimeException e) {
            log.error(issueTabPanel.getClass() + " has thrown an exception from its showPanel() implementation", (Throwable)e);
            ShowPanelReply showPanelReply = ShowPanelReply.create((boolean)true);
            return showPanelReply;
        }
        finally {
            UtilTimerStack.pop((String)timerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetActionsReply invokeGetActions(GetActionsRequest request, IssueTabPanel issueTabPanel) {
        String timerName = "Calling getActions in" + issueTabPanel.getClass();
        UtilTimerStack.push((String)timerName);
        try {
            if (issueTabPanel instanceof IssueTabPanel2) {
                IssueTabPanel2 issueTabPanel2 = (IssueTabPanel2)issueTabPanel;
                GetActionsReply getActionsReply = issueTabPanel2.getActions(request);
                return getActionsReply;
            }
            GetActionsReply issueTabPanel2 = GetActionsReply.create((Iterable)issueTabPanel.getActions(request.issue(), request.remoteUser()));
            return issueTabPanel2;
        }
        catch (RuntimeException e) {
            log.error(issueTabPanel.getClass() + " has thrown an exception from its getActions() implementation", (Throwable)e);
            GetActionsReply getActionsReply = GetActionsReply.create((IssueAction[])new IssueAction[]{new RenderingErrorAction(issueTabPanel)});
            return getActionsReply;
        }
        finally {
            UtilTimerStack.pop((String)timerName);
        }
    }

    private String formatBinaryCompatibilityMessage(IssueTabPanel issueTabPanel, String methodName) {
        return String.format("%s does not implement IssueTabPanel.%s(com.atlassian.jira.issues.Issue, com.atlassian.crowd.embedded.api.User). This likely means the plugin is not compatible with this version of JIRA.", methodName, issueTabPanel.getClass().getName());
    }

    class RenderingErrorAction
    implements IssueAction {
        private final IssueTabPanel issueTabPanel;

        public RenderingErrorAction(IssueTabPanel issueTabPanel) {
            this.issueTabPanel = issueTabPanel;
        }

        public String getHtml() {
            return IssueTabPanelInvokerImpl.this.i18Factory.getInstance(IssueTabPanelInvokerImpl.this.jiraAuthenticationContext.getLoggedInUser()).getText("modulewebcomponent.exception", this.issueTabPanel.getClass().getName());
        }

        public Date getTimePerformed() {
            return new java.sql.Date(System.currentTimeMillis());
        }

        public boolean isDisplayActionAllTab() {
            return true;
        }
    }
}

