/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.component;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.descriptors.RequiresRestart;
import org.dom4j.Element;
import org.picocontainer.MutablePicoContainer;

@RequiresRestart
public class ComponentModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    Class<?> interfaceClazz;
    private String interfaceClazzName;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        if (element.element("interface") != null) {
            this.interfaceClazzName = element.element("interface").getTextTrim();
        }
    }

    public void enabled() {
        if (this.interfaceClazzName != null) {
            try {
                this.interfaceClazz = this.plugin.loadClass(this.interfaceClazzName, ((Object)((Object)this)).getClass());
            }
            catch (Exception e) {
                throw new PluginException("Unable to load interface class: " + this.interfaceClazzName, (Throwable)e);
            }
        }
        super.enabled();
    }

    public void disabled() {
        super.disabled();
        this.interfaceClazz = null;
    }

    public Void getModule() {
        throw new UnsupportedOperationException("You cannot retrieve a component instance - Pico-ified");
    }

    public void registerComponents(MutablePicoContainer container) {
        if (this.interfaceClazzName != null && this.interfaceClazz == null) {
            throw new PluginException("Cannot register component '" + this.interfaceClazzName + "' in plugin '" + this.getKey() + "' because we haven't loaded the class. This means that this plugin has not been successfully enabled.");
        }
        if (container.getComponentAdapter(this.interfaceClazz) != null) {
            container.unregisterComponent(this.interfaceClazz);
        }
        if (this.interfaceClazz != null) {
            container.registerComponentImplementation(this.interfaceClazz, this.getModuleClass());
        } else {
            container.registerComponentImplementation(this.getModuleClass());
        }
    }

    public void unregisterComponents(MutablePicoContainer container) {
        if (this.interfaceClazzName != null && this.interfaceClazz == null) {
            throw new PluginException("Cannot unregister component '" + this.interfaceClazzName + "' in plugin '" + this.getKey() + "' because we haven't loaded the class. This means that this plugin has not been successfully enabled.");
        }
        if (container.getComponentAdapter(this.interfaceClazz) != null) {
            container.unregisterComponent(this.interfaceClazz);
        }
        container.unregisterComponent((Object)this.getModuleClass());
    }
}

