/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultPermissionSchemeManager
extends AbstractSchemeManager
implements PermissionSchemeManager {
    private static final Logger log = Logger.getLogger(DefaultPermissionSchemeManager.class);
    private static final String SCHEME_ENTITY_NAME = "PermissionScheme";
    private static final String PERMISSION_ENTITY_NAME = "SchemePermissions";
    private static final String SCHEME_DESC = "Permission";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.permissions.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.permissions.default.desc";
    private final ConcurrentMap<Long, List<GenericValue>> schemeEntityCache = new ConcurrentHashMap<Long, List<GenericValue>>();
    private final PermissionTypeManager permissionTypeManager;
    private final PermissionContextFactory permissionContextFactory;
    private final OfBizDelegator delegator;

    public DefaultPermissionSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, OfBizDelegator delegator, SchemeFactory schemeFactory, AssociationManager associationManager, GroupManager groupManager) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, associationManager, delegator, groupManager);
        this.permissionTypeManager = permissionTypeManager;
        this.permissionContextFactory = permissionContextFactory;
        this.delegator = delegator;
    }

    @Override
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
        this.flushSchemeEntities();
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return PERMISSION_ENTITY_NAME;
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId) throws GenericEntityException {
        List<GenericValue> entities = this.getEntities(scheme);
        ArrayList<GenericValue> result = new ArrayList<GenericValue>(entities.size());
        for (GenericValue entity : entities) {
            if (!entity.getLong("permission").equals(permissionId)) continue;
            result.add(entity);
        }
        return result;
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId, String parameter) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getEntities(scheme), (Map)MapBuilder.build((Object)"permission", (Object)permissionId, (Object)"parameter", (Object)parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId, String type, String parameter) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getEntities(scheme), (Map)MapBuilder.build((Object)"permission", (Object)permissionId, (Object)"type", (Object)type, (Object)"parameter", (Object)parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long permissionId) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getEntities(scheme), (Map)MapBuilder.build((Object)"permission", (Object)permissionId, (Object)"type", (Object)type));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Permission scheme IDs must be Long values.");
    }

    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme passed must NOT be null");
        }
        if (!(schemeEntity.getEntityTypeId() instanceof Long) && !(schemeEntity.getEntityTypeId() instanceof Integer)) {
            throw new IllegalArgumentException("Permission scheme IDs must be long or int values, not:" + schemeEntity.getEntityTypeId().getClass());
        }
        if (schemeEntity.getType() == null) {
            throw new IllegalArgumentException("Type in SchemeEntity can NOT be null");
        }
        GenericValue perm = EntityUtils.createValue(PERMISSION_ENTITY_NAME, MapBuilder.newBuilder((Object)"scheme", (Object)scheme.getLong("id")).add((Object)"permission", schemeEntity.getEntityTypeId()).add((Object)"type", (Object)schemeEntity.getType()).add((Object)"parameter", (Object)schemeEntity.getParameter()).toMap());
        this.flushSchemeEntities();
        return perm;
    }

    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        super.deleteEntity(id);
        this.flushSchemeEntities();
    }

    @Override
    public GenericValue copySchemeEntity(GenericValue scheme, GenericValue entity) throws GenericEntityException {
        SchemeEntity schemeEntity = new SchemeEntity(entity.getString("type"), entity.getString("parameter"), (Object)entity.getLong("permission"));
        return this.createSchemeEntity(scheme, schemeEntity);
    }

    @Override
    public List<GenericValue> getEntities(GenericValue scheme) throws GenericEntityException {
        List<GenericValue> result;
        Long key = this.getSchemeEntityCacheKey(scheme);
        List<GenericValue> schemeEntities = (List<GenericValue>)this.schemeEntityCache.get(key);
        if (schemeEntities == null && (result = this.schemeEntityCache.putIfAbsent(key, schemeEntities = super.getEntities(scheme))) != null) {
            schemeEntities = result;
        }
        return new ArrayList<GenericValue>(schemeEntities);
    }

    @Override
    public boolean removeEntities(String type, String parameter) throws RemoveException {
        boolean result = super.removeEntities(type, parameter);
        this.flushSchemeEntities();
        return result;
    }

    @Override
    public boolean removeEntities(GenericValue scheme, Long permissionId) throws RemoveException {
        if (Permissions.isGlobalPermission((int)permissionId.intValue())) {
            throw new IllegalArgumentException("PermissionId passed must not be a global permissions " + permissionId.toString() + " is global");
        }
        boolean result = super.removeEntities(scheme, permissionId);
        this.flushSchemeEntities();
        return result;
    }

    public boolean hasSchemeAuthority(Long permissionId, GenericValue project) {
        return this.hasPermission(permissionId, project, null, false);
    }

    public boolean hasSchemeAuthority(Long permissionId, GenericValue project, User user, boolean issueCreation) {
        if (user == null) {
            throw new IllegalArgumentException("The user passed must not be null");
        }
        return this.hasPermission(permissionId, project, user, issueCreation);
    }

    @Override
    public Collection<Group> getGroups(Long entityTypeId, Project project) {
        return this.getGroups(entityTypeId, project.getGenericValue());
    }

    @Override
    public Collection<Group> getGroups(Long entityTypeId, GenericValue project) {
        if (Permissions.isGlobalPermission((int)entityTypeId.intValue())) {
            throw new IllegalArgumentException("PermissionId passed can NOT be a global permission " + entityTypeId.toString() + " is a global");
        }
        return super.getGroups(entityTypeId, project);
    }

    private boolean hasPermission(Long permissionId, GenericValue entity, User user, boolean issueCreation) {
        if (Permissions.isGlobalPermission((int)permissionId.intValue())) {
            throw new IllegalArgumentException("permissionId passed to this function must NOT be a global permission, " + permissionId + " is not");
        }
        if (entity == null) {
            throw new IllegalArgumentException("The entity passed must not be null");
        }
        if (!"Project".equals(entity.getEntityName()) && !"Issue".equals(entity.getEntityName())) {
            throw new IllegalArgumentException("The entity passed must be a Project or an Issue not a " + entity.getEntityName());
        }
        try {
            List schemes = Collections.emptyList();
            if ("Project".equals(entity.getEntityName())) {
                schemes = ManagerFactory.getPermissionSchemeManager().getSchemes(entity);
            } else if ("Issue".equals(entity.getEntityName())) {
                GenericValue project = ManagerFactory.getProjectManager().getProject(entity);
                schemes = ManagerFactory.getPermissionSchemeManager().getSchemes(project);
            }
            for (GenericValue scheme : schemes) {
                if (!this.hasSchemePermission(permissionId, scheme, entity, user, issueCreation)) continue;
                return true;
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
        return false;
    }

    boolean hasSchemePermission(Long permissionId, GenericValue scheme, GenericValue entity, User user, boolean issueCreation) throws GenericEntityException {
        List<GenericValue> entities = this.getEntities(scheme, permissionId);
        Map types = this.permissionTypeManager.getTypes();
        for (GenericValue perm : entities) {
            if (perm == null) continue;
            SchemeType type = (SchemeType)types.get(perm.getString("type"));
            if (!(user == null ? type.hasPermission(entity, perm.getString("parameter")) : (permissionId == null || type.isValidForPermission(permissionId.intValue())) && type.hasPermission(entity, perm.getString("parameter"), user, issueCreation))) continue;
            return true;
        }
        return false;
    }

    private Long getSchemeEntityCacheKey(GenericValue scheme) {
        return scheme.getLong("id");
    }

    public void flushSchemeEntities() {
        this.schemeEntityCache.clear();
    }

    public Collection<GenericValue> getSchemesContainingEntity(String type, String parameter) {
        List entities = this.delegator.findByAnd(PERMISSION_ENTITY_NAME, EasyMap.build((Object)"type", (Object)type, (Object)"parameter", (Object)parameter));
        HashSet<Long> schemeIds = new HashSet<Long>();
        ArrayList<EntityExpr> entityConditions = new ArrayList<EntityExpr>();
        for (GenericValue schemeEntity : entities) {
            schemeIds.add(schemeEntity.getLong("scheme"));
        }
        for (Long id : schemeIds) {
            entityConditions.add(new EntityExpr("id", EntityOperator.EQUALS, (Object)id));
        }
        List schemes = !entityConditions.isEmpty() ? this.delegator.findByOr(SCHEME_ENTITY_NAME, entityConditions, Collections.EMPTY_LIST) : Collections.emptyList();
        return schemes;
    }
}

