/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.DefaultOfBizListIterator;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.FieldSupportValidator;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.filters.ThreadLocalQueryProfiler;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionParam;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericDataSourceException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.jdbc.AutoCommitSQLProcessor;
import org.ofbiz.core.entity.jdbc.SQLProcessor;
import org.ofbiz.core.entity.jdbc.SqlJdbcUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelReader;

public class DefaultOfBizDelegator
implements OfBizDelegator {
    private static final Logger log = Logger.getLogger(DefaultOfBizDelegator.class);
    private static final int DEFAULT_DATABASE_QUERY_BATCH_SIZE = 100;
    private static final String COUNT_FIELD_NAME = "count";
    private static final Collection<String> UNSUPPORTED_TYPES_FOR_FINDBY = CollectionBuilder.newBuilder((Object[])new String[]{"very-long", "extremely-long", "text", "blob"}).asCollection();
    private final DelegatorInterface delegatorInterface;
    private final FieldSupportValidator findByValidator;

    public static int getQueryBatchSize() {
        String size = null;
        try {
            size = ComponentAccessor.getApplicationProperties().getDefaultBackedString("jira.databasequery.batch.size");
            return Integer.parseInt(size);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Error while converting database query batch size '" + size + "'. Using default value of " + 100));
            return 100;
        }
    }

    public DefaultOfBizDelegator(DelegatorInterface delegatorInterface) {
        this.delegatorInterface = delegatorInterface;
        this.findByValidator = new FieldSupportValidator("findBy", UNSUPPORTED_TYPES_FOR_FINDBY, new FieldTypeResolver());
    }

    public List<GenericValue> findByField(String entityName, String fieldName, Object fieldValue) {
        return this.findByAnd(entityName, (Map<String, ?>)new FieldMap(fieldName, fieldValue));
    }

    public List<GenericValue> findByField(String entityName, String fieldName, Object fieldValue, String orderBy) {
        return this.findByAnd(entityName, (Map<String, ?>)new FieldMap(fieldName, fieldValue), CollectionBuilder.list((Object[])new String[]{orderBy}));
    }

    public List<GenericValue> findByAnd(String entityName, Map<String, ?> fields) throws DataAccessException {
        this.findByValidator.checkAll(entityName, fields.keySet());
        try {
            return this.delegatorInterface.findByAnd(entityName, fields);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<GenericValue> findByAnd(String entityName, Map<String, ?> fields, List<String> orderBy) throws DataAccessException {
        this.findByValidator.checkAll(entityName, fields.keySet());
        try {
            return this.delegatorInterface.findByAnd(entityName, fields, orderBy);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<GenericValue> findByAnd(String entityName, List<EntityCondition> expressions) throws DataAccessException {
        try {
            return this.delegatorInterface.findByAnd(entityName, expressions);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<GenericValue> findByOr(String entityName, List expressions, List orderBy) throws DataAccessException {
        try {
            if (orderBy != null) {
                return this.delegatorInterface.findByOr(entityName, expressions, orderBy);
            }
            return this.delegatorInterface.findByOr(entityName, expressions);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<GenericValue> findByLike(String s, Map<String, ?> map) throws DataAccessException {
        return this.findByLike(s, map, Collections.<String>emptyList());
    }

    public List<GenericValue> findByLike(String s, Map<String, ?> map, List<String> orderBy) throws DataAccessException {
        try {
            return this.delegatorInterface.findByLike(s, map, orderBy);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void removeAll(List<GenericValue> genericValues) throws DataAccessException {
        try {
            this.delegatorInterface.removeAll(genericValues);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<GenericValue> findByCondition(String entityName, EntityCondition entityCondition, Collection<String> fieldsToSelect) {
        return this.findByCondition(entityName, entityCondition, fieldsToSelect, Collections.<String>emptyList());
    }

    public List<GenericValue> findByCondition(String entityName, EntityCondition entityCondition, Collection<String> fieldsToSelect, List<String> orderBy) {
        try {
            return this.delegatorInterface.findByCondition(entityName, entityCondition, fieldsToSelect, orderBy);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeByOr(String entityName, String entityId, List<Long> ids) throws DataAccessException, GenericModelException {
        int result = 0;
        ModelEntity modelEntity = this.delegatorInterface.getModelEntity(entityName);
        if (modelEntity == null) {
            throw new GenericModelException("The entityName passed in was not valid: " + entityName);
        }
        if (!modelEntity.isField(entityId)) {
            throw new GenericModelException("The entityId passed in was not valid for the given entity: " + entityId);
        }
        ModelField modelField = modelEntity.getField(entityId);
        try {
            GenericHelper entityHelper = this.delegatorInterface.getEntityHelper(entityName);
            StringBuffer removeSql = new StringBuffer("DELETE FROM ");
            removeSql.append(modelEntity.getTableName(entityHelper.getHelperName()));
            removeSql.append(" WHERE ");
            removeSql.append(modelField.getColName());
            removeSql.append(" IN (");
            int idsSize = ids.size();
            ArrayList<Long> idParams = new ArrayList<Long>();
            StringBuffer idClause = new StringBuffer();
            int batchSize = DefaultOfBizDelegator.getQueryBatchSize();
            int batchIndex = 0;
            for (int i = 0; i < idsSize; ++i) {
                boolean isEndOfIdList;
                idParams.add(ids.get(i));
                idClause.append("?");
                boolean isEndOfBatch = batchIndex == batchSize - 1;
                boolean bl = isEndOfIdList = i == idsSize - 1;
                if (isEndOfBatch || isEndOfIdList) {
                    AutoCommitSQLProcessor processor = new AutoCommitSQLProcessor(entityHelper.getHelperName());
                    idClause.append(")");
                    try {
                        processor.prepareStatement(removeSql.toString() + idClause.toString());
                        for (Long idParam : idParams) {
                            processor.setValue(idParam);
                        }
                        result += processor.executeUpdate();
                        idParams.clear();
                        idClause = new StringBuffer();
                        batchIndex = 0;
                        continue;
                    }
                    finally {
                        try {
                            processor.close();
                        }
                        catch (GenericDataSourceException e) {
                            log.warn((Object)"Could not close the SQLProcessor", (Throwable)e);
                        }
                    }
                }
                idClause.append(", ");
                ++batchIndex;
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        return result;
    }

    public int removeByAnd(String entityName, Map map) throws DataAccessException {
        try {
            return this.delegatorInterface.removeByAnd(entityName, map);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public int removeById(String entityName, Long id) {
        return this.removeByAnd(entityName, (Map)FieldMap.build((String)"id", (Object)id));
    }

    public int removeValue(GenericValue value) throws DataAccessException {
        try {
            return this.delegatorInterface.removeValue(value);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void storeAll(List genericValues) throws DataAccessException {
        try {
            this.delegatorInterface.storeAll(genericValues);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<GenericValue> findAll(String s) {
        try {
            return this.delegatorInterface.findAll(s);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<GenericValue> findAll(String s, List sortOrder) throws DataAccessException {
        try {
            return this.delegatorInterface.findAll(s, sortOrder);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void store(GenericValue gv) throws DataAccessException {
        try {
            this.delegatorInterface.store(gv);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public GenericValue createValue(String entityName, Map<String, Object> fields) {
        try {
            return EntityUtils.createValue(entityName, fields);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public GenericValue makeValue(String entityName) {
        return this.delegatorInterface.makeValue(entityName, null);
    }

    public GenericValue makeValue(String entityName, Map<String, Object> fields) {
        return this.delegatorInterface.makeValue(entityName, fields);
    }

    public GenericValue findByPrimaryKey(String entityName, Long id) {
        HashMap<String, Long> fields = new HashMap<String, Long>();
        fields.put("id", id);
        return this.findByPrimaryKey(entityName, fields);
    }

    public GenericValue findByPrimaryKey(String entityName, Map fields) {
        long start = System.currentTimeMillis();
        try {
            GenericValue genericValue = this.delegatorInterface.findByPrimaryKey(entityName, fields);
            return genericValue;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            ThreadLocalQueryProfiler.store("OfBizDelegator", "findByPrimaryKey", System.currentTimeMillis() - start);
        }
    }

    public List<GenericValue> getRelated(String relationName, GenericValue gv) {
        try {
            return this.delegatorInterface.getRelated(relationName, gv);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public long getCount(String entityName) {
        long count;
        try {
            EntityFieldMap condition = new EntityFieldMap(EasyMap.build(), EntityOperator.AND);
            GenericValue countGV = EntityUtil.getOnly((List)this.delegatorInterface.findByCondition(entityName + "Count", (EntityCondition)condition, (Collection)EasyList.build((Object)COUNT_FIELD_NAME), Collections.EMPTY_LIST));
            count = countGV.getLong(COUNT_FIELD_NAME);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            return 0L;
        }
        return count;
    }

    public OfBizListIterator findListIteratorByCondition(String entityType, EntityCondition condition) {
        try {
            return new DefaultOfBizListIterator(this.delegatorInterface.findListIteratorByCondition(entityType, condition, null, null));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public OfBizListIterator findListIteratorByCondition(String entityName, EntityCondition whereEntityCondition, EntityCondition havingEntityCondition, Collection fieldsToSelect, List orderBy, EntityFindOptions entityFindOptions) {
        try {
            return new DefaultOfBizListIterator(this.delegatorInterface.findListIteratorByCondition(entityName, whereEntityCondition, havingEntityCondition, fieldsToSelect, orderBy, entityFindOptions));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkUpdateByPrimaryKey(String entityName, Map<String, ?> updateValues, List<Long> keys) {
        int result = 0;
        if (entityName == null || updateValues == null || updateValues.isEmpty() || keys == null || keys.isEmpty()) {
            return 0;
        }
        try {
            int i;
            GenericHelper entityHelper = this.delegatorInterface.getEntityHelper(entityName);
            ModelEntity modelEntity = this.delegatorInterface.getModelEntity(entityName);
            List pks = modelEntity.getPkFieldNames();
            if (pks.size() != 1) {
                throw new DataAccessException("BulkUpdateByPrimaryKey only works for single column keys at this moment.");
            }
            String pkName = (String)pks.get(0);
            Updater updater = new Updater(ModelFieldTypeReader.getModelFieldTypeReader((String)entityHelper.getHelperName()), entityName);
            ArrayList<Updater.Value> params = new ArrayList<Updater.Value>();
            StringBuffer updateSql = new StringBuffer("UPDATE ");
            updateSql.append(modelEntity.getTableName(entityHelper.getHelperName()));
            updateSql.append(" SET ");
            Iterator<String> iterator = updateValues.keySet().iterator();
            while (iterator.hasNext()) {
                String column = iterator.next();
                updateSql.append(" ");
                ModelField field = modelEntity.getField(column);
                updateSql.append(field.getColName());
                updateSql.append(" = ");
                params.add(updater.create(field, updateValues.get(column)));
                updateSql.append("? ");
                if (!iterator.hasNext()) continue;
                updateSql.append(", ");
            }
            updateSql.append(" WHERE ");
            int batchSize = DefaultOfBizDelegator.getQueryBatchSize();
            for (int currentIndex = 0; currentIndex < keys.size(); currentIndex += i) {
                StringBuffer idClause = new StringBuffer();
                ArrayList<Long> idParams = new ArrayList<Long>();
                Iterator<Long> iterator2 = keys.subList(currentIndex, keys.size()).iterator();
                for (i = 0; iterator2.hasNext() && i < batchSize; ++i) {
                    Long key = iterator2.next();
                    idClause.append(" ");
                    idClause.append(pkName);
                    idClause.append(" = ");
                    idParams.add(key);
                    idClause.append("? ");
                    if (!iterator2.hasNext() || i + 1 >= batchSize) continue;
                    idClause.append(" or ");
                }
                AutoCommitSQLProcessor processor = new AutoCommitSQLProcessor(entityHelper.getHelperName());
                processor.prepareStatement(updateSql.toString() + idClause.toString());
                for (Updater.Value param : params) {
                    param.setValue((SQLProcessor)processor);
                }
                for (Long idParam : idParams) {
                    processor.setValue(idParam);
                }
                try {
                    result = processor.executeUpdate();
                    continue;
                }
                finally {
                    processor.close();
                }
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkUpdateByAnd(String entityName, Map<String, ?> updateValues, Map<String, ?> criteria) {
        int result = 0;
        if (entityName == null || updateValues == null || updateValues.isEmpty()) {
            return 0;
        }
        try {
            ModelEntity modelEntity = this.delegatorInterface.getModelEntity(entityName);
            GenericHelper entityHelper = this.delegatorInterface.getEntityHelper(entityName);
            ModelFieldTypeReader modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader((String)entityHelper.getHelperName());
            ArrayList<EntityConditionParam> params = new ArrayList<EntityConditionParam>();
            StringBuffer updateSql = new StringBuffer("UPDATE ");
            updateSql.append(modelEntity.getTableName(entityHelper.getHelperName()));
            updateSql.append(" SET ");
            if (!modelEntity.areFields(updateValues.keySet())) {
                throw new GenericModelException("At least one of the passed fields for update is not valid: " + updateValues.keySet().toString());
            }
            Iterator<String> iterator = updateValues.keySet().iterator();
            while (iterator.hasNext()) {
                String fieldName = iterator.next();
                updateSql.append(" ");
                ModelField modelField = modelEntity.getField(fieldName);
                updateSql.append(modelField.getColName());
                updateSql.append(" = ");
                params.add(new EntityConditionParam(modelField, updateValues.get(fieldName)));
                updateSql.append("? ");
                if (!iterator.hasNext()) continue;
                updateSql.append(", ");
            }
            if (criteria != null && !criteria.isEmpty()) {
                if (!modelEntity.areFields(criteria.keySet())) {
                    throw new GenericModelException("At least one of the passed fields is not valid: " + criteria.keySet().toString());
                }
                EntityFieldMap entityCondition = new EntityFieldMap(criteria, EntityOperator.AND);
                String entityCondWhereString = entityCondition.makeWhereString(modelEntity, params);
                if (entityCondWhereString.length() > 0) {
                    updateSql.append(" WHERE ");
                    updateSql.append(entityCondWhereString);
                }
            }
            AutoCommitSQLProcessor processor = new AutoCommitSQLProcessor(entityHelper.getHelperName());
            String sql = updateSql.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running bulk update SQL: '" + sql + "'"));
            }
            processor.prepareStatement(sql);
            for (EntityConditionParam conditionParam : params) {
                SqlJdbcUtil.setValue((SQLProcessor)processor, (ModelField)conditionParam.getModelField(), (String)modelEntity.getEntityName(), (Object)conditionParam.getFieldValue(), (ModelFieldTypeReader)modelFieldTypeReader);
            }
            try {
                result = processor.executeUpdate();
            }
            finally {
                processor.close();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkCopyColumnValuesByAnd(String entityName, Map updateColumns, Map criteria) {
        int result = 0;
        if (entityName == null || updateColumns == null || updateColumns.isEmpty()) {
            return 0;
        }
        try {
            ModelEntity modelEntity = this.delegatorInterface.getModelEntity(entityName);
            GenericHelper entityHelper = this.delegatorInterface.getEntityHelper(entityName);
            ModelFieldTypeReader modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader((String)entityHelper.getHelperName());
            ArrayList params = new ArrayList();
            StringBuffer updateSql = new StringBuffer("UPDATE ");
            updateSql.append(modelEntity.getTableName(entityHelper.getHelperName()));
            updateSql.append(" SET ");
            if (!modelEntity.areFields(updateColumns.keySet())) {
                throw new GenericModelException("At least one of the passed fields for update is not valid: " + updateColumns.keySet().toString());
            }
            if (!modelEntity.areFields(updateColumns.values())) {
                throw new GenericModelException("At least one of the passed fields for update is not valid: " + updateColumns.values().toString());
            }
            Iterator iterator = updateColumns.keySet().iterator();
            while (iterator.hasNext()) {
                String column = (String)iterator.next();
                updateSql.append(" ");
                ModelField toModelField = modelEntity.getField(column);
                updateSql.append(toModelField.getColName());
                updateSql.append(" = ");
                ModelField fromModelField = modelEntity.getField((String)updateColumns.get(column));
                updateSql.append(fromModelField.getColName());
                if (!iterator.hasNext()) continue;
                updateSql.append(", ");
            }
            if (criteria != null && !criteria.isEmpty()) {
                if (!modelEntity.areFields(criteria.keySet())) {
                    throw new GenericModelException("At least one of the passed fields is not valid: " + criteria.keySet().toString());
                }
                EntityFieldMap entityCondition = new EntityFieldMap(criteria, EntityOperator.AND);
                String entityCondWhereString = entityCondition.makeWhereString(modelEntity, params);
                if (entityCondWhereString.length() > 0) {
                    updateSql.append(" WHERE ");
                    updateSql.append(entityCondWhereString);
                }
            }
            AutoCommitSQLProcessor processor = new AutoCommitSQLProcessor(entityHelper.getHelperName());
            String sql = updateSql.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running bulk update SQL: '" + sql + "'"));
            }
            processor.prepareStatement(sql);
            for (EntityConditionParam conditionParam : params) {
                SqlJdbcUtil.setValue((SQLProcessor)processor, (ModelField)conditionParam.getModelField(), (String)modelEntity.getEntityName(), (Object)conditionParam.getFieldValue(), (ModelFieldTypeReader)modelFieldTypeReader);
            }
            try {
                result = processor.executeUpdate();
            }
            finally {
                processor.close();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        return result;
    }

    public ModelReader getModelReader() {
        return this.delegatorInterface.getModelReader();
    }

    public void refreshSequencer() {
        this.delegatorInterface.refreshSequencer();
    }

    class FieldTypeResolver
    implements Function<String, Function<String, String>> {
        FieldTypeResolver() {
        }

        public Function<String, String> get(String entityName) {
            final ModelEntity table = DefaultOfBizDelegator.this.delegatorInterface.getModelEntity(entityName);
            return table == null ? null : new Function<String, String>(){

                public String get(String fieldName) {
                    ModelField field = table.getField(fieldName);
                    return field == null ? null : field.getType();
                }
            };
        }
    }

    static final class Updater {
        final ModelFieldTypeReader modelFieldTypeReader;
        final String entityName;

        Updater(@NotNull ModelFieldTypeReader modelFieldTypeReader, @NotNull String entityName) {
            this.modelFieldTypeReader = (ModelFieldTypeReader)Assertions.notNull((String)"modelFieldTypeReader", (Object)modelFieldTypeReader);
            this.entityName = (String)Assertions.notNull((String)"entityName", (Object)entityName);
        }

        public Value create(ModelField field, Object value) {
            return new Value(field, value);
        }

        class Value {
            final ModelField field;
            final Object value;

            Value(ModelField field, Object value) {
                this.field = field;
                this.value = value;
            }

            void setValue(SQLProcessor processor) throws GenericEntityException {
                SqlJdbcUtil.setValue((SQLProcessor)processor, (ModelField)this.field, (String)Updater.this.entityName, (Object)this.value, (ModelFieldTypeReader)Updater.this.modelFieldTypeReader);
            }
        }
    }
}

