/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.velocity.VelocityManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class UserMailQueueItem
extends AbstractMailQueueItem {
    private static final Logger log = Logger.getLogger(UserMailQueueItem.class);
    private static final String EMAIL_TEMPLATES = "templates/email/";
    private static final Integer PADSIZE = 20;
    private final UserEvent event;
    private final String subjectKey;
    private final String template;

    public UserMailQueueItem(UserEvent event, String subject, String subjectKey, String template) {
        super(subject);
        this.event = event;
        this.subjectKey = subjectKey;
        this.template = template;
    }

    public void send() throws MailException {
        this.incrementSendCount();
        try {
            User user = this.event.getUser();
            if (user != null) {
                String to = user.getEmailAddress();
                Map<String, Object> params = this.getUserContextParamsBody(this.event);
                params.put("initiatingUser", this.event.getInitiatingUser());
                I18nBean i18nBean = new I18nBean(user);
                params.put("i18n", i18nBean);
                params.put("stringUtils", new StringUtils());
                params.put("padSize", PADSIZE);
                VelocityManager velocityManager = ManagerFactory.getVelocityManager();
                ApplicationProperties applicationProperties = ManagerFactory.getApplicationProperties();
                String body = velocityManager.getEncodedBody(EMAIL_TEMPLATES, "text/" + this.template, (String)this.event.getParams().get("baseurl"), applicationProperties.getString("webwork.i18n.encoding"), params);
                Email email = new Email(to);
                email.setSubject(i18nBean.getText(this.getSubjectKey()));
                email.setBody(body);
                email.setMimeType("text/plain");
                ManagerFactory.getMailQueue().addItem((MailQueueItem)new SingleMailQueueItem((com.atlassian.mail.Email)email));
            } else {
                log.warn((Object)("Mail with subject '" + this.getSubject() + "' not sent since user '" + user + "' no longer exists."));
            }
        }
        catch (Exception ex) {
            throw new MailException((Throwable)ex);
        }
    }

    public String getSubjectKey() {
        return this.subjectKey;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }

    protected Map<String, Object> getUserContextParamsBody(UserEvent uEvent) {
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        contextParams.put("user", uEvent.getUser());
        contextParams.put("params", uEvent.getParams());
        return JiraMailQueueUtils.getContextParamsBody(contextParams);
    }
}

