/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.velocity.VelocityManager;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class MentionsMailQueueItem
extends SingleMailQueueItem {
    private static final Logger log = Logger.getLogger(MentionsMailQueueItem.class);
    private Map<String, Object> params;
    private String template;

    public MentionsMailQueueItem(Email email, String template, Map<String, Object> params) {
        super(email);
        this.params = params;
        this.template = template;
    }

    public String getSubject() {
        I18nHelper i18n = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        try {
            Map<String, Object> contextParams = JiraMailQueueUtils.getContextParamsBody(this.params);
            contextParams.put("i18n", i18n);
            return ComponentAccessor.getVelocityManager().getEncodedBody("templates/email/", "share-email-subject.vm", this.getMailEncoding(), this.params);
        }
        catch (Exception e) {
            log.error((Object)"Could not determine subject", (Throwable)e);
            return i18n.getText("bulk.bean.initialise.error");
        }
    }

    public void send() throws MailException {
        this.params = JiraMailQueueUtils.getContextParamsBody(this.params);
        String mailEncoding = ComponentAccessor.getApplicationProperties().getMailEncoding();
        try {
            VelocityManager velocityManager = ComponentAccessor.getVelocityManager();
            String subject = velocityManager.getEncodedBody("templates/email/", "subject/issuementioned.vm", mailEncoding, this.params);
            String body = velocityManager.getEncodedBody("templates/email/", this.template, mailEncoding, this.params);
            this.getEmail().setSubject(subject);
            this.getEmail().setBody(body);
        }
        catch (VelocityException e) {
            throw new RuntimeException(e);
        }
        super.send();
    }

    private String getMailEncoding() {
        return ComponentAccessor.getApplicationProperties().getMailEncoding();
    }
}

