/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.changehistory.JqlChangeItemMapping;
import com.atlassian.jira.issue.index.ChangeHistoryFieldConfigurationManager;
import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.PredicateOperandResolver;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.validator.HistoryFieldValueValidator;
import com.atlassian.jira.jql.validator.HistoryPredicateValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.ChangedClause;

public class ChangedClauseValidator {
    private final IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager;
    private final SearchHandlerManager searchHandlerManager;
    private final ChangeHistoryManager changeHistoryManager;
    private final PredicateOperandResolver predicateOperandResolver;
    private final JqlDateSupport jqlDateSupport;
    private final HistoryPredicateValidator historyPredicateValidator;
    private final JiraAuthenticationContext authContext;
    private final JqlChangeItemMapping jqlChangeItemMapping;
    private final ChangeHistoryFieldConfigurationManager configurationManager;
    private final HistoryFieldValueValidator historyFieldValueValidator;

    public ChangedClauseValidator(JqlOperandResolver operandResolver, SearchHandlerManager searchHandlerManager, IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager, ChangeHistoryManager changeHistoryManager, PredicateOperandResolver predicateOperandResolver, JqlDateSupport jqlDateSupport, JiraAuthenticationContext authContext, JqlChangeItemMapping jqlChangeItemMapping, ChangeHistoryFieldConfigurationManager configurationManager, HistoryFieldValueValidator historyFieldValueValidator) {
        this.searchHandlerManager = searchHandlerManager;
        this.indexedChangeHistoryFieldManager = indexedChangeHistoryFieldManager;
        this.jqlChangeItemMapping = jqlChangeItemMapping;
        this.configurationManager = configurationManager;
        this.changeHistoryManager = changeHistoryManager;
        this.predicateOperandResolver = predicateOperandResolver;
        this.jqlDateSupport = jqlDateSupport;
        this.authContext = authContext;
        this.historyFieldValueValidator = historyFieldValueValidator;
        this.historyPredicateValidator = this.getHistoryPredicateValidator();
    }

    private HistoryPredicateValidator getHistoryPredicateValidator() {
        return new HistoryPredicateValidator(this.authContext, this.predicateOperandResolver, this.jqlDateSupport, this.searchHandlerManager, this.configurationManager, this.historyFieldValueValidator);
    }

    public MessageSet validate(User searcher, ChangedClause clause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        this.validateField(searcher, clause.getField(), (MessageSet)messageSet);
        if (clause.getPredicate() != null) {
            messageSet.addMessageSet(this.historyPredicateValidator.validate(searcher, clause, clause.getPredicate()));
        }
        return messageSet;
    }

    private void validateField(User searcher, String fieldName, MessageSet messages) {
        if (!this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFieldNames().contains(fieldName.toLowerCase())) {
            messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.history.field.not.supported", fieldName));
        }
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }
}

