/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.changehistory.ChangeHistoryFieldConstants;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.filters.IssueIdFilter;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import com.atlassian.jira.jql.query.HistoryPredicateQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.util.lucene.ConstantScorePrefixQuery;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.operator.Operator;
import java.io.IOException;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;

public class ChangedClauseQueryFactory {
    private static final Logger log = Logger.getLogger(ChangedClauseQueryFactory.class);
    private final SearchProviderFactory searchProviderFactory;
    private final HistoryPredicateQueryFactory changedPredicateQueryFactory;
    private final ChangeHistoryFieldConstants changeHistoryFieldConstants;

    public ChangedClauseQueryFactory(SearchProviderFactory searchProviderFactory, HistoryPredicateQueryFactory changedPredicateQueryFactory, ChangeHistoryFieldConstants changeHistoryFieldConstants) {
        this.searchProviderFactory = searchProviderFactory;
        this.changedPredicateQueryFactory = changedPredicateQueryFactory;
        this.changeHistoryFieldConstants = changeHistoryFieldConstants;
    }

    public QueryFactoryResult create(User searcher, ChangedClause clause) {
        ConstantScoreQuery issueQuery;
        Query changedQuery = this.makeQuery(searcher, clause);
        IndexSearcher historySearcher = this.searchProviderFactory.getSearcher("changes");
        final HashSet<String> queryIds = new HashSet<String>();
        final HashSet allIssueIds = new HashSet();
        DocumentHitCollector Collector2 = new DocumentHitCollector(historySearcher){

            public void collect(Document doc) {
                queryIds.add(doc.get("issue_id"));
            }
        };
        DocumentHitCollector allDocsCollector = new DocumentHitCollector(historySearcher){

            public void collect(Document doc) {
                allIssueIds.add(doc.get("issue_id"));
            }
        };
        try {
            HashSet<String> issueIds;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running Changed query (" + clause + "): " + changedQuery));
            }
            historySearcher.search(changedQuery, (Collector)Collector2);
            if (clause.getOperator() == Operator.CHANGED) {
                issueIds = queryIds;
            } else {
                historySearcher.search((Query)new MatchAllDocsQuery(), (Collector)allDocsCollector);
                allIssueIds.removeAll(queryIds);
                issueIds = allIssueIds;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("History query returned: " + issueIds));
            }
            issueQuery = new ConstantScoreQuery((Filter)new IssueIdFilter(issueIds));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new QueryFactoryResult((Query)issueQuery);
    }

    private Query makeQuery(User searcher, ChangedClause clause) {
        BooleanQuery outerQuery = new BooleanQuery();
        BooleanQuery changedQuery = new BooleanQuery();
        ConstantScorePrefixQuery toQuery = this.createQuery(clause, "ch_from");
        if (clause.getPredicate() == null) {
            changedQuery.add((Query)toQuery, BooleanClause.Occur.SHOULD);
        } else {
            BooleanQuery predicateQuery = this.changedPredicateQueryFactory.makePredicateQuery(searcher, clause.getField().toLowerCase(), clause.getPredicate(), true);
            changedQuery.add((Query)predicateQuery, BooleanClause.Occur.MUST);
            changedQuery.add((Query)toQuery, BooleanClause.Occur.MUST);
        }
        outerQuery.add((Query)changedQuery, BooleanClause.Occur.SHOULD);
        return outerQuery;
    }

    private ConstantScorePrefixQuery createQuery(ChangedClause clause, String documentField) {
        return new ConstantScorePrefixQuery(new Term(clause.getField().toLowerCase() + "." + documentField, "ch-"));
    }
}

