/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.AllTextCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AllTextClauseQueryFactory
implements ClauseQueryFactory {
    private final CustomFieldManager customFieldManager;
    private final SearchHandlerManager searchHandlerManager;

    public AllTextClauseQueryFactory(CustomFieldManager customFieldManager, SearchHandlerManager searchHandlerManager) {
        this.customFieldManager = (CustomFieldManager)Assertions.notNull((String)"customFieldManager", (Object)customFieldManager);
        this.searchHandlerManager = (SearchHandlerManager)Assertions.notNull((String)"searchHandlerManager", (Object)searchHandlerManager);
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (operator != Operator.LIKE) {
            return QueryFactoryResult.createFalseResult();
        }
        List<ClauseQueryFactory> factories = this.getFactories(queryCreationContext);
        ArrayList<QueryFactoryResult> results = new ArrayList<QueryFactoryResult>(factories.size());
        for (ClauseQueryFactory clauseQueryFactory : factories) {
            results.add(clauseQueryFactory.getQuery(queryCreationContext, terminalClause));
        }
        return QueryFactoryResult.mergeResultsWithShould(results);
    }

    List<ClauseQueryFactory> getFactories(QueryCreationContext queryCreationContext) {
        CollectionBuilder factoryCollectionBuilder = CollectionBuilder.newBuilder();
        factoryCollectionBuilder.addAll(this.getAllSystemFieldFactories(queryCreationContext));
        factoryCollectionBuilder.addAll(this.getAllCustomFieldFactories(queryCreationContext));
        return factoryCollectionBuilder.asList();
    }

    List<ClauseQueryFactory> getAllSystemFieldFactories(QueryCreationContext queryCreationContext) {
        ArrayList<ClauseQueryFactory> factories = new ArrayList<ClauseQueryFactory>();
        List systemFieldClauseNames = CollectionBuilder.newBuilder((Object[])new String[]{SystemSearchConstants.forComments().getJqlClauseNames().getPrimaryName(), SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName(), SystemSearchConstants.forEnvironment().getJqlClauseNames().getPrimaryName(), SystemSearchConstants.forSummary().getJqlClauseNames().getPrimaryName()}).asList();
        for (String clauseName : systemFieldClauseNames) {
            Collection<ClauseHandler> handlers = this.getHandlersForClauseName(queryCreationContext, clauseName);
            for (ClauseHandler handler : handlers) {
                factories.add(handler.getFactory());
            }
        }
        return factories;
    }

    List<ClauseQueryFactory> getAllCustomFieldFactories(QueryCreationContext queryCreationContext) {
        ArrayList<ClauseQueryFactory> factories = new ArrayList<ClauseQueryFactory>();
        List allCustomFields = this.customFieldManager.getCustomFieldObjects();
        for (CustomField customField : allCustomFields) {
            CustomFieldSearcherClauseHandler fieldSearcherClauseHandler;
            CustomFieldSearcher searcher = customField.getCustomFieldSearcher();
            if (searcher == null || (fieldSearcherClauseHandler = searcher.getCustomFieldSearcherClauseHandler()) == null || !(fieldSearcherClauseHandler instanceof AllTextCustomFieldSearcherClauseHandler) || !fieldSearcherClauseHandler.getSupportedOperators().contains(Operator.LIKE)) continue;
            Collection<ClauseHandler> handlers = this.getHandlersForClauseName(queryCreationContext, customField.getClauseNames().getPrimaryName());
            for (ClauseHandler handler : handlers) {
                factories.add(handler.getFactory());
            }
        }
        return factories;
    }

    private Collection<ClauseHandler> getHandlersForClauseName(QueryCreationContext queryCreationContext, String primaryClauseName) {
        if (queryCreationContext.isSecurityOverriden()) {
            return this.searchHandlerManager.getClauseHandler(primaryClauseName);
        }
        return this.searchHandlerManager.getClauseHandler(queryCreationContext.getQueryUser(), primaryClauseName);
    }
}

