/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.util;

import com.google.common.collect.Lists;
import com.mindprod.csv.CSVReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;

public class CsvTag
extends TagSupport {
    private String var;
    private File file;
    private String uri;

    public void doTag(XMLOutput xmlOutput) throws JellyTagException {
        InputStreamReader reader;
        if (this.var == null) {
            throw new MissingAttributeException("This tag must have a 'var' attribute to store the CSV object in");
        }
        if (this.file == null && this.uri == null) {
            throw new JellyTagException("This tag must have a 'file' or 'uri' specified");
        }
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new JellyTagException("The file: " + this.file + " does not exist");
            }
            try {
                reader = new FileReader(this.file);
            }
            catch (FileNotFoundException e) {
                throw new JellyTagException("could not find the file", (Throwable)e);
            }
        } else {
            InputStream in = this.context.getResourceAsStream(this.uri);
            if (in == null) {
                throw new JellyTagException("Could not find uri: " + this.uri);
            }
            reader = new InputStreamReader(in);
        }
        CSVReader csv = new CSVReader((Reader)reader);
        ArrayList allRows = Lists.newArrayList();
        try {
            while (true) {
                List<String> row = Arrays.asList(csv.getAllFieldsInLine());
                allRows.add(row);
            }
        }
        catch (EOFException e) {
            this.context.setVariable(this.var, (Object)allRows);
        }
        catch (IOException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

