/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.issue.enterprise;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.jelly.IssueContextAccessor;
import com.atlassian.jira.jelly.ProjectContextAccessor;
import com.atlassian.jira.jelly.enterprise.IssueSchemeLevelAware;
import com.atlassian.jira.jelly.tag.issue.AbstractCreateIssue;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.user.util.UserManager;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class CreateIssue
extends AbstractCreateIssue
implements IssueSchemeLevelAware,
ProjectContextAccessor,
IssueContextAccessor {
    private static final Logger log = Logger.getLogger(CreateIssue.class);

    public CreateIssue(VersionManager versionManager, UserManager userManager) {
        super(versionManager, userManager);
    }

    @Override
    protected void preContextValidation() {
        super.preContextValidation();
        try {
            String securityLevel = this.getProperty("security-level");
            if (securityLevel != null) {
                List schemes = ManagerFactory.getIssueSecuritySchemeManager().getSchemes(this.getProject());
                for (int i = 0; i < schemes.size(); ++i) {
                    GenericValue scheme = (GenericValue)schemes.get(i);
                    List schemeIssueSecurityLevels = ManagerFactory.getIssueSecurityLevelManager().getSchemeIssueSecurityLevels(scheme.getLong("id"));
                    for (int j = 0; j < schemeIssueSecurityLevels.size(); ++j) {
                        GenericValue securityLevelGV = (GenericValue)schemeIssueSecurityLevels.get(j);
                        if (!securityLevel.equals(securityLevelGV.getString("name"))) continue;
                        this.setPreviousIssueSchemeLevelId(this.getIssueSchemeLevelId());
                        this.getContext().setVariable("jelly.issue.scheme.level.id", (Object)securityLevelGV.getLong("id"));
                        j = schemeIssueSecurityLevels.size();
                        i = schemes.size();
                    }
                }
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        if (this.hasIssueSchemeLevel()) {
            this.setProperty("security", this.getIssueSchemeLevelId().toString());
        } else {
            this.getProperties().remove("security");
        }
        super.prePropertyValidation(output);
    }

    @Override
    public boolean hasIssueSchemeLevel() {
        return this.getContext().getVariables().containsKey("jelly.issue.scheme.level.id");
    }

    @Override
    public Long getIssueSchemeLevelId() {
        if (this.hasIssueSchemeLevel()) {
            return (Long)this.getContext().getVariable("jelly.issue.scheme.level.id");
        }
        return null;
    }

    @Override
    public GenericValue getIssueSchemeLevel() {
        try {
            return ManagerFactory.getIssueSecurityLevelManager().getIssueSecurityLevel(this.getIssueSchemeLevelId());
        }
        catch (GenericEntityException e) {
            return null;
        }
    }
}

