/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jelly.GroupAware;
import com.atlassian.jira.jelly.GroupContextAccessor;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Tag;

public class GroupContextAccessorImpl
implements GroupContextAccessor,
GroupAware {
    private final Tag tag;
    private boolean hasGroup = false;
    private String group = null;

    public GroupContextAccessorImpl(Tag tag) {
        this.tag = tag;
    }

    @Override
    public JellyContext getContext() {
        return this.tag.getContext();
    }

    @Override
    public void setGroup(String groupname) {
        this.setPreviousGroup();
        this.resetGroupContext();
        this.setNewUserContext(groupname);
    }

    @Override
    public void setGroup(Group group) {
        this.setPreviousGroup();
        this.resetGroupContext();
        this.setGroupContext(group);
    }

    @Override
    public void loadPreviousGroup() {
        if (this.hasGroup) {
            this.resetGroupContext();
            this.setGroup(this.group);
            this.hasGroup = false;
            this.group = null;
        }
    }

    private void setPreviousGroup() {
        if (this.hasGroup()) {
            this.hasGroup = true;
            this.group = this.getGroupName();
        }
    }

    private void resetGroupContext() {
        this.getContext().removeVariable("jelly.group.name");
    }

    private void setNewUserContext(String groupname) {
        Group group = ComponentAccessor.getGroupManager().getGroup(groupname);
        this.setGroupContext(group);
    }

    private void setGroupContext(Group group) {
        this.getContext().setVariable("jelly.group.name", (Object)group.getName());
    }

    @Override
    public boolean hasGroup() {
        return this.getContext().getVariables().containsKey("jelly.group.name");
    }

    @Override
    public String getGroupName() {
        if (this.hasGroup()) {
            return (String)this.getContext().getVariable("jelly.group.name");
        }
        return null;
    }

    @Override
    public Group getGroup() {
        return ComponentAccessor.getGroupManager().getGroup(this.getGroupName());
    }
}

