/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class CommentAction
extends AbstractIssueAction {
    private final Comment comment;
    private final Issue issue;
    private final boolean canEditComment;
    private final boolean canDeleteComment;
    private final RendererManager rendererManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final DateTimeFormatter dateTimeFormatter;
    private static final Logger log = Logger.getLogger(CommentAction.class);

    public CommentAction(IssueTabPanelModuleDescriptor descriptor, Comment comment, boolean canEditComment, boolean canDeleteComment, RendererManager rendererManager, FieldLayoutManager fieldLayoutManager, DateTimeFormatter dateTimeFormatter) {
        super(descriptor);
        this.comment = comment;
        this.dateTimeFormatter = dateTimeFormatter;
        this.issue = comment.getIssue();
        this.canEditComment = canEditComment;
        this.canDeleteComment = canDeleteComment;
        this.rendererManager = rendererManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public Date getTimePerformed() {
        return this.comment.getCreated();
    }

    protected void populateVelocityParams(Map params) {
        params.put("action", this);
        try {
            FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(this.issue.getProjectObject(), this.issue.getIssueTypeObject().getId()).getFieldLayoutItem("comment");
            if (fieldLayoutItem != null) {
                params.put("renderedContent", this.rendererManager.getRenderedContent(fieldLayoutItem.getRendererType(), this.comment.getBody(), this.issue.getIssueRenderContext()));
            }
        }
        catch (DataAccessException e) {
            log.error((Object)e);
        }
    }

    public Comment getComment() {
        return this.comment;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public boolean isCanEditComment() {
        return this.canEditComment;
    }

    public boolean isCanDeleteComment() {
        return this.canDeleteComment;
    }

    public String formatDisplayHtml(Date date) {
        if (date == null) {
            return null;
        }
        DateTimeFormatter completeFormatter = this.dateTimeFormatter().withStyle(DateTimeStyle.COMPLETE);
        return StringEscapeUtils.escapeHtml((String)completeFormatter.format(date));
    }

    public String formatIso8601Html(Date date) {
        if (date == null) {
            return null;
        }
        DateTimeFormatter iso8601Formatter = this.dateTimeFormatter().withStyle(DateTimeStyle.ISO_8601_DATE_TIME);
        return StringEscapeUtils.escapeHtml((String)iso8601Formatter.format(date));
    }

    protected DateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter.forLoggedInUser();
    }
}

