/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.impl.WorkRatioIndexer;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AbstractInitializationSearcher;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.WorkRatioSearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.WorkRatioSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.WorkRatioSearcherConfig;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.velocity.VelocityManager;
import java.util.Collections;

public class WorkRatioSearcher
extends AbstractInitializationSearcher
implements IssueSearcher<SearchableField> {
    private final SearcherInformation<SearchableField> searcherInformation;
    private final SearchInputTransformer searchInputTransformer;
    private final SearchRenderer searchRenderer;

    public WorkRatioSearcher(JqlOperandResolver operandResolver, ApplicationProperties applicationProperties, VelocityRequestContextFactory velocityRenderContext, VelocityManager velocityManager, FieldVisibilityManager fieldVisibilityManager) {
        SimpleFieldSearchConstants constants = SystemSearchConstants.forWorkRatio();
        WorkRatioSearcherConfig config = new WorkRatioSearcherConfig(constants.getJqlClauseNames().getPrimaryName());
        String nameKey = "navigator.filter.workratio.limits";
        this.searcherInformation = new GenericSearcherInformation(constants.getSearcherId(), "navigator.filter.workratio.limits", Collections.singletonList(WorkRatioIndexer.class), this.fieldReference, SearcherGroupType.WORK);
        this.searchInputTransformer = new WorkRatioSearchInputTransformer(constants, config, operandResolver);
        this.searchRenderer = new WorkRatioSearchRenderer(velocityRenderContext, applicationProperties, velocityManager, constants, "navigator.filter.workratio.limits", fieldVisibilityManager, config);
    }

    public final SearcherInformation<SearchableField> getSearchInformation() {
        return this.searcherInformation;
    }

    public final SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    public final SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }
}

