/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.issue.search.quicksearch.PrefixedSingleWordQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ProjectAwareQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ProjectAwareQuickSearchHandlerImpl;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.map.MultiValueMap;
import org.ofbiz.core.entity.GenericValue;

public class ComponentQuickSearchHandler
extends PrefixedSingleWordQuickSearchHandler {
    private static final String PREFIX = "c:";
    private final ProjectComponentManager projectComponentManager;
    private final ProjectAwareQuickSearchHandler projectAwareQuickSearchHandler;

    public ComponentQuickSearchHandler(ProjectComponentManager projectComponentManager, ProjectManager projectManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.projectComponentManager = projectComponentManager;
        this.projectAwareQuickSearchHandler = new ProjectAwareQuickSearchHandlerImpl(projectManager, permissionManager, authenticationContext);
    }

    @Override
    protected Map handleWordSuffix(String wordSuffix, QuickSearchResult searchResult) {
        List possibleProjects = this.projectAwareQuickSearchHandler.getProjects(searchResult);
        MultiValueMap components = new MultiValueMap();
        for (GenericValue project : possibleProjects) {
            this.getComponentsByName(project, wordSuffix, (Map)components);
        }
        return components;
    }

    @Override
    protected String getPrefix() {
        return PREFIX;
    }

    private void getComponentsByName(GenericValue project, String word, Map components) {
        this.getAllNamesMatchingSubstring(this.projectComponentManager.findAllForProject(project.getLong("id")), word, components);
    }

    protected void getAllNamesMatchingSubstring(Collection projectComponents, String name, Map existingComponents) {
        for (ProjectComponent projectComponent : projectComponents) {
            String componentName = projectComponent.getName();
            if (componentName == null) continue;
            StringTokenizer st = new StringTokenizer(componentName, " ");
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (!name.equalsIgnoreCase(word)) continue;
                existingComponents.put("component", projectComponent.getId().toString());
            }
        }
    }
}

