/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.renderers.FieldRenderContext;
import com.atlassian.jira.plugin.renderer.JiraRendererModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DefaultRendererManager
implements RendererManager {
    private static final Logger log = Logger.getLogger(DefaultRendererManager.class);
    private static final String PLUGIN_TYPE = "com.atlassian.jira.plugin.system.jirarenderers";
    private final PluginAccessor pluginAccessor;

    public DefaultRendererManager(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public List<JiraRendererPlugin> getAllActiveRenderers() {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(JiraRendererModuleDescriptor.class);
        ArrayList<JiraRendererPlugin> renderers = new ArrayList<JiraRendererPlugin>(descriptors.size());
        for (JiraRendererModuleDescriptor descriptor : descriptors) {
            renderers.add((JiraRendererPlugin)descriptor.getModule());
        }
        return renderers;
    }

    public JiraRendererPlugin getRendererForType(String rendererType) {
        JiraRendererPlugin renderer = this.getRendererPluginForType(rendererType);
        if (renderer == null && (renderer = this.getRendererPluginForType("jira-text-renderer")) == null) {
            throw new IllegalStateException("The default text renderer for Jira has been disabled, please re-enable the text renderer for correct funtioning to resume.");
        }
        return renderer;
    }

    public JiraRendererPlugin getRendererForField(FieldLayoutItem fieldConfig) {
        String rendererType = fieldConfig != null ? fieldConfig.getRendererType() : null;
        return this.getRendererForType(rendererType);
    }

    public String getRenderedContent(FieldLayoutItem fieldConfig, Issue issue) {
        if (!(fieldConfig.getOrderableField() instanceof RenderableField)) {
            log.warn((Object)("Attempting to get renderered content from a field that is not of type RendererableField, offending field is: " + fieldConfig.getOrderableField().getId()));
            throw new IllegalArgumentException("Attempting to get renderered content from a field that is not of type RendererableField, offending field is: " + fieldConfig.getOrderableField().getId());
        }
        IssueRenderContext renderContext = issue.getIssueRenderContext();
        RenderableField renderField = (RenderableField)fieldConfig.getOrderableField();
        JiraRendererPlugin rendererPlugin = this.getRendererForField(fieldConfig);
        return rendererPlugin.render(renderField.getValueFromIssue(issue), renderContext);
    }

    public String getRenderedContent(String rendererType, String value, IssueRenderContext renderContext) {
        JiraRendererPlugin rendererPlugin = this.getRendererForType(rendererType);
        return rendererPlugin.render(value, renderContext);
    }

    public String getRenderedContent(FieldRenderContext fieldRenderContext) {
        Issue issue = fieldRenderContext.getIssue();
        String fieldId = fieldRenderContext.getFieldId();
        FieldLayoutManager fieldLayoutManager = ComponentManager.getComponentInstanceOfType(FieldLayoutManager.class);
        FieldLayoutItem fieldLayoutItem = fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeObject().getId()).getFieldLayoutItem(fieldId);
        if (fieldLayoutItem != null) {
            return this.getRenderedContent(fieldLayoutItem.getRendererType(), fieldRenderContext.getBody(), issue.getIssueRenderContext());
        }
        return null;
    }

    private JiraRendererPlugin getRendererPluginForType(String rendererType) {
        List rendererPlugins = this.pluginAccessor.getEnabledModulesByClass(JiraRendererPlugin.class);
        for (JiraRendererPlugin rendererPlugin : rendererPlugins) {
            if (!rendererPlugin.getRendererType().equals(rendererType)) continue;
            return rendererPlugin;
        }
        return null;
    }
}

