/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraException;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkCreator;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.issue.link.LinkCollectionImpl;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.CollectionReorderer;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueLinkManager
implements IssueLinkManager,
Startable {
    private static final Logger log = Logger.getLogger(DefaultIssueLinkManager.class);
    private final OfBizDelegator delegator;
    private final IssueLinkCreator issueLinkCreator;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final CollectionReorderer collectionReorderer;
    private final IssueUpdater issueUpdater;
    private final IssueIndexManager issueIndexManager;
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private Map<Map, List<GenericValue>> cache;

    public DefaultIssueLinkManager(OfBizDelegator genericDelegator, IssueLinkCreator issueLinkCreator, IssueLinkTypeManager issueLinkTypeManager, CollectionReorderer collectionReorderer, IssueUpdater issueUpdater, IssueIndexManager issueIndexManager, ApplicationProperties applicationProperties, EventPublisher eventPublisher) {
        this.delegator = genericDelegator;
        this.issueLinkCreator = issueLinkCreator;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.collectionReorderer = collectionReorderer;
        this.issueUpdater = issueUpdater;
        this.issueIndexManager = issueIndexManager;
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
        this.cache = Collections.synchronizedMap(new LRUMap(1000));
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId, Long sequence, User remoteUser) throws CreateException {
        if (this.getIssueLink(sourceId, destinationId, issueLinkTypeId) != null) {
            return;
        }
        IssueLink issueLink = null;
        try {
            issueLink = this.storeIssueLink(sourceId, destinationId, issueLinkTypeId, sequence);
            IssueLinkType issueLinkType = issueLink.getIssueLinkType();
            if (!issueLinkType.isSystemLinkType()) {
                this.createCreateIssueLinkChangeItems(issueLink, issueLinkType, remoteUser);
            }
        }
        finally {
            this.clearCache();
            if (issueLink != null) {
                this.reindexLinkedIssues(issueLink);
            }
        }
    }

    protected void reindexLinkedIssues(IssueLink issueLink) {
        try {
            this.issueIndexManager.reIndex(issueLink.getSourceObject());
            this.issueIndexManager.reIndex(issueLink.getDestinationObject());
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }

    private void createCreateIssueLinkChangeItems(IssueLink issueLink, IssueLinkType issueLinkType, User remoteUser) throws CreateException {
        Issue source = issueLink.getSourceObject();
        Issue destination = issueLink.getDestinationObject();
        try {
            ChangeItemBean cib = new ChangeItemBean("jira", "Link", null, null, destination.getKey(), "This issue " + issueLinkType.getOutward() + " " + destination.getKey());
            this.createChangeItem(source.getGenericValue(), cib, remoteUser);
            cib = new ChangeItemBean("jira", "Link", null, null, source.getKey(), "This issue " + issueLinkType.getInward() + " " + source.getKey());
            this.createChangeItem(destination.getGenericValue(), cib, remoteUser);
        }
        catch (Exception e) {
            throw new CreateException("Error occurred while creating change item for creating issue link between entity with id '" + issueLink.getSourceId() + "' and entity with id '" + issueLink.getDestinationId() + "'.", e);
        }
    }

    private void createChangeItem(GenericValue issue, ChangeItemBean changeItemBean, User remoteUser) throws JiraException {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue, issue, EventType.ISSUE_UPDATED_ID, remoteUser);
        issueUpdateBean.setDispatchEvent(false);
        issueUpdateBean.setChangeItems((Collection)EasyList.build((Object)changeItemBean));
        this.issueUpdater.doUpdate(issueUpdateBean, true);
    }

    public void removeIssueLink(IssueLink issueLink, User remoteUser) throws RemoveException {
        this.removeIssueLinkInternal(issueLink, remoteUser, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIssueLinkInternal(IssueLink issueLink, User remoteUser, boolean createChangeItem) throws RemoveException {
        if (issueLink == null) {
            throw new IllegalArgumentException("Link cannot be null");
        }
        try {
            IssueLinkType issueLinkType;
            this.delegator.removeByAnd("IssueLink", EasyMap.build((Object)"id", (Object)issueLink.getId()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleted link with id '" + issueLink.getId() + "'."));
            }
            if (createChangeItem && !(issueLinkType = issueLink.getIssueLinkType()).isSystemLinkType()) {
                this.createRemoveIssueLinkChangeItems(issueLink, issueLinkType, remoteUser);
            }
        }
        finally {
            this.clearCache();
            this.reindexLinkedIssues(issueLink);
        }
    }

    private void createRemoveIssueLinkChangeItems(IssueLink issueLink, IssueLinkType issueLinkType, User remoteUser) throws RemoveException {
        try {
            Issue source = issueLink.getSourceObject();
            Issue destination = issueLink.getDestinationObject();
            ChangeItemBean cib = new ChangeItemBean("jira", "Link", destination.getKey(), "This issue " + issueLinkType.getOutward() + " " + destination.getKey(), null, null);
            this.createChangeItem(source.getGenericValue(), cib, remoteUser);
            cib = new ChangeItemBean("jira", "Link", source.getKey(), "This issue " + issueLinkType.getInward() + " " + source.getKey(), null, null);
            this.createChangeItem(destination.getGenericValue(), cib, remoteUser);
        }
        catch (Exception e) {
            throw new RemoveException("Error occurred while creating change item for removing issue issue link with id '" + issueLink.getId() + "'.", e);
        }
    }

    public int removeIssueLinks(Issue issue, User remoteUser) throws RemoveException {
        return this.removeIssueLinks(issue.getGenericValue(), remoteUser);
    }

    public int removeIssueLinks(GenericValue issue, User remoteUser) throws RemoveException {
        if (issue == null) {
            return 0;
        }
        return this.removeIssueLinksInternal(issue, remoteUser, true);
    }

    public int removeIssueLinksNoChangeItems(Issue issue) throws RemoveException {
        return this.removeIssueLinksInternal(issue.getGenericValue(), null, false);
    }

    private int removeIssueLinksInternal(GenericValue issue, User remoteUser, boolean createChangeItem) throws RemoveException {
        List<IssueLink> outwardLinks = this.getOutwardLinks(issue.getLong("id"));
        this.deleteIssueLinksFromIssue(outwardLinks, remoteUser, createChangeItem);
        int totalLinksDeleted = outwardLinks.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted " + outwardLinks.size() + " outward links from issue " + issue.getString("key")));
        }
        List<IssueLink> inwardLinks = this.getInwardLinks(issue.getLong("id"));
        this.deleteIssueLinksFromIssue(inwardLinks, remoteUser, createChangeItem);
        totalLinksDeleted += inwardLinks.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted " + inwardLinks.size() + " inward links from issue " + issue.getString("key")));
        }
        if (totalLinksDeleted > 0) {
            this.clearCache();
        }
        return totalLinksDeleted;
    }

    private void deleteIssueLinksFromIssue(List<IssueLink> issueLinks, User remoteUser, boolean createChangeItem) throws RemoveException {
        if (issueLinks != null) {
            for (IssueLink issueLink : issueLinks) {
                this.removeIssueLinkInternal(issueLink, remoteUser, createChangeItem);
            }
        }
    }

    public LinkCollection getLinkCollection(GenericValue issue, User remoteUser) {
        TreeSet<IssueLinkType> linkTypes = new TreeSet<IssueLinkType>();
        HashMap<String, List<Issue>> outwardLinkMap = new HashMap<String, List<Issue>>();
        Long issueId = issue.getLong("id");
        List<IssueLink> outwardLinks = this.getOutwardLinks(issueId);
        if (outwardLinks != null) {
            for (IssueLink issueLink : outwardLinks) {
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLink.getLinkTypeId());
                if (issueLinkType.isSystemLinkType()) continue;
                linkTypes.add(issueLinkType);
                Issue linkedIssue = issueLink.getDestinationObject();
                this.storeInLinkMap(outwardLinkMap, issueLinkType.getName(), linkedIssue);
            }
        }
        List<IssueLink> inwardLinks = this.getInwardLinks(issueId);
        HashMap<String, List<Issue>> inwardLinkMap = new HashMap<String, List<Issue>>();
        if (inwardLinks != null) {
            for (IssueLink issueLink : inwardLinks) {
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLink.getLinkTypeId());
                if (issueLinkType.isSystemLinkType()) continue;
                linkTypes.add(issueLinkType);
                Issue linkedIssue = issueLink.getSourceObject();
                this.storeInLinkMap(inwardLinkMap, issueLinkType.getName(), linkedIssue);
            }
        }
        return new LinkCollectionImpl(issueId, linkTypes, outwardLinkMap, inwardLinkMap, remoteUser, this.applicationProperties);
    }

    public LinkCollection getLinkCollection(Issue issue, User remoteUser) {
        return this._getLinkCollection(issue, remoteUser, false, true);
    }

    public LinkCollection getLinkCollection(Issue issue, User remoteUser, boolean excludeSystemLinks) {
        return this._getLinkCollection(issue, remoteUser, false, excludeSystemLinks);
    }

    public LinkCollection getLinkCollectionOverrideSecurity(Issue issue) {
        return this._getLinkCollection(issue, null, true, true);
    }

    private LinkCollection _getLinkCollection(Issue issue, User remoteUser, boolean overrideSecurity, boolean excludeSystemLinks) {
        TreeSet<IssueLinkType> linkTypes = new TreeSet<IssueLinkType>();
        HashMap<String, List<Issue>> outwardLinkMap = new HashMap<String, List<Issue>>();
        List<IssueLink> outwardLinks = this.getOutwardLinks(issue.getId());
        if (outwardLinks != null) {
            for (IssueLink issueLink : outwardLinks) {
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLink.getLinkTypeId(), excludeSystemLinks);
                if (excludeSystemLinks && issueLinkType.isSystemLinkType()) continue;
                linkTypes.add(issueLinkType);
                Issue linkedIssue = issueLink.getDestinationObject();
                this.storeInLinkMap(outwardLinkMap, issueLinkType.getName(), linkedIssue);
            }
        }
        List<IssueLink> inwardLinks = this.getInwardLinks(issue.getId());
        HashMap<String, List<Issue>> inwardLinkMap = new HashMap<String, List<Issue>>();
        if (inwardLinks != null) {
            for (IssueLink issueLink : inwardLinks) {
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLink.getLinkTypeId(), excludeSystemLinks);
                if (excludeSystemLinks && issueLinkType.isSystemLinkType()) continue;
                linkTypes.add(issueLinkType);
                Issue linkedIssue = issueLink.getSourceObject();
                this.storeInLinkMap(inwardLinkMap, issueLinkType.getName(), linkedIssue);
            }
        }
        return new LinkCollectionImpl(issue.getId(), linkTypes, outwardLinkMap, inwardLinkMap, remoteUser, overrideSecurity, this.applicationProperties);
    }

    public List<IssueLink> getOutwardLinks(Long sourceId) {
        List<GenericValue> issueLinkGVs = this.getLinks(EasyMap.build((Object)"source", (Object)sourceId));
        return this.buildIssueLinks(issueLinkGVs);
    }

    public List<IssueLink> getInwardLinks(Long id) {
        List<GenericValue> issueLinkGVs = this.getLinks(EasyMap.build((Object)"destination", (Object)id));
        return this.buildIssueLinks(issueLinkGVs);
    }

    public void moveIssueLink(List<IssueLink> issueLinks, Long currentSequence, Long sequence) {
        if (currentSequence == null) {
            throw new IllegalArgumentException("Current sequence cannot be null.");
        }
        if (sequence == null) {
            throw new IllegalArgumentException("Sequence cannot be null.");
        }
        int currentIndex = currentSequence.intValue();
        int index = sequence.intValue();
        this.collectionReorderer.moveToPosition(issueLinks, currentIndex, index);
        this.resetSequences(issueLinks);
    }

    public void resetSequences(List<IssueLink> issueLinks) {
        this.recalculateSequences(issueLinks);
        this.storeIssueLinks(issueLinks);
    }

    public IssueLink getIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId) {
        GenericValue linkGV = EntityUtil.getFirst(this.getLinks(EasyMap.build((Object)"source", (Object)sourceId, (Object)"destination", (Object)destinationId, (Object)"linktype", (Object)issueLinkTypeId)));
        if (linkGV == null) {
            return null;
        }
        return this.buildIssueLink(linkGV);
    }

    public Collection<IssueLink> getIssueLinks(Long issueLinkTypeId) {
        return this.buildIssueLinks(this.getLinks(EasyMap.build((Object)"linktype", (Object)issueLinkTypeId)));
    }

    public IssueLink getIssueLink(Long issueLinkId) {
        Assertions.notNull((String)"issueLinkId", (Object)issueLinkId);
        GenericValue issueLinkGV = this.delegator.findByPrimaryKey("IssueLink", issueLinkId);
        if (issueLinkGV == null) {
            return null;
        }
        return this.issueLinkCreator.createIssueLink(issueLinkGV);
    }

    public void changeIssueLinkType(IssueLink issueLink, IssueLinkType swapLinkType, User remoteUser) throws RemoveException {
        IssueLinkType oldIssueLinkType = issueLink.getIssueLinkType();
        if (!oldIssueLinkType.isSystemLinkType() && swapLinkType.isSystemLinkType()) {
            log.warn((Object)"Changing non-system link type to a system link type.");
        } else if (oldIssueLinkType.isSystemLinkType() && !swapLinkType.isSystemLinkType()) {
            log.warn((Object)"Changing system link type to a non-system link type.");
        }
        this.setIssueLinkType(issueLink, swapLinkType);
        if (!oldIssueLinkType.isSystemLinkType()) {
            try {
                this.createRemoveIssueLinkChangeItems(issueLink, oldIssueLinkType, remoteUser);
                this.createCreateIssueLinkChangeItems(issueLink, swapLinkType, remoteUser);
            }
            catch (Exception e) {
                throw new RemoveException("Error occurred while removing issue changing issue link type for issue link with id '" + issueLink.getLong("id") + "'.");
            }
        }
        issueLink.store();
        this.clearCache();
    }

    private void setIssueLinkType(IssueLink issueLink, IssueLinkType issueLinkType) {
        if (issueLinkType == null) {
            throw new IllegalArgumentException("Cannot set link type to null.");
        }
        issueLink.getGenericValue().set("linktype", (Object)issueLinkType.getId());
    }

    public boolean isLinkingEnabled() {
        return this.applicationProperties.getOption("jira.option.issuelinking");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IssueLink storeIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId, Long sequence) {
        try {
            Map fields = EasyMap.build((Object)"source", (Object)sourceId, (Object)"destination", (Object)destinationId, (Object)"linktype", (Object)issueLinkTypeId, (Object)"sequence", (Object)sequence);
            IssueLink issueLink = this.buildIssueLink(this.delegator.createValue("IssueLink", fields));
            return issueLink;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeIssueLinks(Collection<IssueLink> issueLinks) {
        try {
            for (IssueLink issueLink : issueLinks) {
                issueLink.store();
            }
        }
        finally {
            this.clearCache();
        }
    }

    private void recalculateSequences(List<IssueLink> issueLinks) {
        long i = 0L;
        for (IssueLink issueLink : issueLinks) {
            issueLink.getGenericValue().set("sequence", (Object)i);
            ++i;
        }
    }

    private List<IssueLink> buildIssueLinks(Collection<GenericValue> issueLinkGVs) {
        ArrayList<IssueLink> issueLinks = new ArrayList<IssueLink>();
        for (GenericValue issueLinkGV : issueLinkGVs) {
            issueLinks.add(this.buildIssueLink(issueLinkGV));
        }
        return issueLinks;
    }

    private IssueLink buildIssueLink(GenericValue issueLinkGV) {
        return this.issueLinkCreator.createIssueLink(issueLinkGV);
    }

    private void storeInLinkMap(Map<String, List<Issue>> linkMap, String linkTypeName, Issue linkedIssue) {
        List<Issue> matchingLinks = linkMap.get(linkTypeName);
        if (matchingLinks == null) {
            matchingLinks = new ArrayList<Issue>();
            linkMap.put(linkTypeName, matchingLinks);
        }
        matchingLinks.add(linkedIssue);
    }

    private List<GenericValue> getLinks(Map criteria) {
        List result = this.cache.get(criteria);
        if (result == null) {
            result = this.delegator.findByAnd("IssueLink", criteria);
            if (result == null) {
                result = Collections.emptyList();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caching " + result.size() + " links for query criteria: " + criteria));
            }
            this.cache.put(criteria, result);
        }
        return result;
    }

    public void clearCache() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing issue link cache, had " + this.cache.size() + " entries"));
        }
        this.cache.clear();
    }
}

