/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumberTools;
import org.ofbiz.core.entity.GenericEntityException;

public abstract class BaseFieldIndexer
implements FieldIndexer {
    private static final Logger log = Logger.getLogger(BaseFieldIndexer.class);
    private final FieldVisibilityManager fieldVisibilityManager;

    protected BaseFieldIndexer(FieldVisibilityManager fieldVisibilityManager) {
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    Field.Index unanalyzed(Issue issue) {
        return this.isFieldVisibleAndInScope(issue) ? Field.Index.NOT_ANALYZED_NO_NORMS : Field.Index.NO;
    }

    public void indexKeyword(Document doc, String indexField, String fieldValue, Issue issue) {
        if (StringUtils.isNotBlank((String)fieldValue)) {
            doc.add((Fieldable)new Field(indexField, fieldValue, Field.Store.YES, this.unanalyzed(issue)));
        }
    }

    public void indexFoldedKeyword(Document doc, String indexField, String fieldValue, Locale locale, Issue issue) {
        if (StringUtils.isNotBlank((String)fieldValue)) {
            Locale actualLocale;
            Locale locale2 = actualLocale = locale == null ? Locale.getDefault() : locale;
            if (this.isFieldVisibleAndInScope(issue)) {
                doc.add((Fieldable)new Field(indexField, CaseFolding.foldString((String)fieldValue, (Locale)actualLocale), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
        }
    }

    public void indexKeywordWithDefault(Document doc, String indexField, String fieldValue, String defaultValue, Issue issue) {
        FieldIndexerUtil.indexKeywordWithDefault(doc, indexField, fieldValue, defaultValue, this.isFieldVisibleAndInScope(issue));
    }

    public void indexKeywordWithDefault(Document doc, String indexField, Long aLong, String defaultValue, Issue issue) {
        String value = aLong != null ? aLong.toString() : null;
        this.indexKeywordWithDefault(doc, indexField, value, defaultValue, issue);
    }

    public void indexLongAsPaddedKeywordWithDefault(Document doc, String indexField, Long aLong, String defaultValue, Issue issue) {
        String value = aLong != null ? NumberTools.longToString((long)aLong) : null;
        this.indexKeywordWithDefault(doc, indexField, value, defaultValue, issue);
    }

    public void indexLongAsPaddedKeywordWithDefault(Document doc, String indexField, Long aLong, Long defaultLong, Issue issue) {
        String value = aLong != null ? NumberTools.longToString((long)aLong) : null;
        String defaultValue = defaultLong != null ? NumberTools.longToString((long)defaultLong) : null;
        this.indexKeywordWithDefault(doc, indexField, value, defaultValue, issue);
    }

    public void indexText(Document doc, String indexField, String fieldValue, Issue issue) {
        if (StringUtils.isNotBlank((String)fieldValue)) {
            if (this.isFieldVisibleAndInScope(issue)) {
                doc.add((Fieldable)new Field(indexField, fieldValue, Field.Store.YES, Field.Index.ANALYZED));
            } else {
                doc.add((Fieldable)new Field(indexField, fieldValue, Field.Store.YES, Field.Index.NO));
            }
        }
    }

    public void indexDateField(Document doc, String indexField, Timestamp date, Issue issue) {
        if (date != null) {
            doc.add((Fieldable)new Field(indexField, LuceneUtils.dateToString((Date)date), Field.Store.YES, this.unanalyzed(issue)));
        }
    }

    public void indexLocalDateField(Document doc, String indexField, LocalDate localDate, Issue issue) {
        if (localDate != null) {
            doc.add((Fieldable)new Field(indexField, LuceneUtils.localDateToString((LocalDate)localDate), Field.Store.YES, this.unanalyzed(issue)));
        }
    }

    public void indexDependentEntities(Issue issue, Document doc, String associationType, String indexField) {
        String sinkName;
        if (associationType.equals("IssueComponent")) {
            sinkName = "Component";
        } else if (associationType.equals("IssueFixVersion")) {
            sinkName = "Version";
        } else if (associationType.equals("IssueVersion")) {
            sinkName = "Version";
        } else {
            throw new IllegalArgumentException("Assocation Type " + associationType + " not handled");
        }
        try {
            List<Long> ids = ((AssociationManager)ComponentAccessor.getComponent(AssociationManager.class)).getSinkIdsFromSource(issue.getGenericValue(), sinkName, associationType);
            if (ids == null || ids.isEmpty()) {
                doc.add((Fieldable)new Field(indexField, "-1", Field.Store.YES, this.unanalyzed(issue)));
            } else {
                Field.Index index = this.unanalyzed(issue);
                for (Long id : ids) {
                    doc.add((Fieldable)new Field(indexField, id.toString(), Field.Store.YES, index));
                }
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)("Could not retrieve dependencies for issue :" + issue + " : " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public void indexLongAsKeyword(Document doc, String indexField, Long fieldValue, Issue issue) {
        if (fieldValue != null) {
            doc.add((Fieldable)new Field(indexField, fieldValue.toString(), Field.Store.YES, this.unanalyzed(issue)));
        }
    }

    public void indexTextForSorting(Document doc, String indexField, String fieldValue, Issue issue) {
        String string = FieldIndexerUtil.getValueForSorting(fieldValue);
        if (StringUtils.isNotBlank((String)string)) {
            doc.add((Fieldable)new Field(indexField, string, Field.Store.YES, this.unanalyzed(issue)));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof FieldIndexer)) {
            return false;
        }
        FieldIndexer rhs = (FieldIndexer)o;
        return new EqualsBuilder().append((Object)this.getId(), (Object)rhs.getId()).isEquals();
    }

    public int hashCode() {
        return this.getId().hashCode() * 41;
    }

    public int compareTo(Object obj) {
        FieldIndexer o = (FieldIndexer)obj;
        return new CompareToBuilder().append((Object)this.getId(), (Object)o.getId()).toComparison();
    }

    public boolean isFieldVisibleAndInScope(Issue issue) {
        return !this.fieldVisibilityManager.isFieldHidden(this.getId(), issue);
    }
}

