/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenStore;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.set.ListOrderedSet;

public class DefaultFieldScreenManager
implements FieldScreenManager {
    private final FieldScreenStore fieldScreenStore;

    public DefaultFieldScreenManager(FieldScreenStore fieldScreenStore) {
        this.fieldScreenStore = fieldScreenStore;
        this.fieldScreenStore.setFieldScreenManager(this);
        this.fieldScreenStore.refresh();
    }

    public FieldScreen getFieldScreen(Long id) {
        return this.fieldScreenStore.getFieldScreen(id);
    }

    public Collection<FieldScreen> getFieldScreens() {
        return this.fieldScreenStore.getFieldScreens();
    }

    public Collection<FieldScreenTab> getFieldScreenTabs(String fieldId) {
        ListOrderedSet fieldScreenTabs = new ListOrderedSet();
        for (FieldScreen fieldScreen : this.getFieldScreens()) {
            for (FieldScreenTab fieldScreenTab : fieldScreen.getTabs()) {
                if (fieldScreenTab.getFieldScreenLayoutItem(fieldId) == null) continue;
                fieldScreenTabs.add(fieldScreenTab);
            }
        }
        return fieldScreenTabs;
    }

    public void createFieldScreen(FieldScreen fieldScreen) {
        this.fieldScreenStore.createFieldScreen(fieldScreen);
    }

    public void removeFieldScreen(Long id) {
        this.fieldScreenStore.removeFieldScreen(id);
    }

    public void updateFieldScreen(FieldScreen fieldScreen) {
        this.fieldScreenStore.updateFieldScreen(fieldScreen);
    }

    public void createFieldScreenTab(FieldScreenTab fieldScreenTab) {
        this.fieldScreenStore.createFieldScreenTab(fieldScreenTab);
    }

    public void updateFieldScreenTab(FieldScreenTab fieldScreenTab) {
        this.fieldScreenStore.updateFieldScreenTab(fieldScreenTab);
    }

    public FieldScreenTab getFieldScreenTab(Long fieldScreenTabId) {
        return this.fieldScreenStore.getFieldScreenTab(fieldScreenTabId);
    }

    public List<FieldScreenTab> getFieldScreenTabs(FieldScreen fieldScreen) {
        return this.fieldScreenStore.getFieldScreenTabs(fieldScreen);
    }

    public void createFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.fieldScreenStore.createFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    public void updateFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.fieldScreenStore.updateFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    public void removeFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.fieldScreenStore.removeFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    public void removeFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        this.fieldScreenStore.removeFieldScreenLayoutItems(fieldScreenTab);
    }

    public List<FieldScreenLayoutItem> getFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        return this.fieldScreenStore.getFieldScreenLayoutItems(fieldScreenTab);
    }

    public void removeFieldScreenItems(String fieldId) {
        for (FieldScreen fieldScreen : this.getFieldScreens()) {
            if (!fieldScreen.containsField(fieldId)) continue;
            fieldScreen.removeFieldScreenLayoutItem(fieldId);
        }
    }

    public void refresh() {
        this.fieldScreenStore.refresh();
    }

    public FieldScreenLayoutItem buildNewFieldScreenLayoutItem(String fieldId) {
        FieldScreenLayoutItem fieldScreenLayoutItem = this.fieldScreenStore.buildNewFieldScreenLayoutItem(null);
        fieldScreenLayoutItem.setFieldId(fieldId);
        return fieldScreenLayoutItem;
    }

    public void removeFieldScreenTabs(FieldScreen fieldScreen) {
        this.fieldScreenStore.removeFieldScreenTabs(fieldScreen);
    }

    public void removeFieldScreenTab(Long id) {
        this.fieldScreenStore.removeFieldScreenTab(id);
    }
}

