/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.search.handlers.WorkRatioSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.LongFieldStatisticsMapper;
import com.atlassian.jira.issue.worklog.WorkRatio;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.velocity.VelocityManager;
import java.util.Map;
import javax.annotation.Nullable;

public class WorkRatioSystemField
extends NavigableFieldImpl
implements SearchableField,
RestAwareField {
    private final SearchHandlerFactory searcherHandlerFactory;

    public WorkRatioSystemField(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, WorkRatioSearchHandlerFactory handlerFactory) {
        super("workratio", "issue.field.workratio", "issue.column.heading.workratio", "ASC", velocityManager, applicationProperties, authenticationContext);
        this.searcherHandlerFactory = handlerFactory;
    }

    public LuceneFieldSorter getSorter() {
        return LongFieldStatisticsMapper.WORK_RATIO;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        if (this.isWorkEstimateExists(issue)) {
            velocityParams.put(this.getId(), new Long(this.getWorkRatio(issue)));
        }
        return this.renderTemplate("workratio-columnview.vm", velocityParams);
    }

    private boolean isWorkEstimateExists(Issue issue) {
        return issue.getOriginalEstimate() != null;
    }

    public long getWorkRatio(Issue issue) {
        return WorkRatio.getWorkRatio((Issue)issue);
    }

    public SearchHandler createAssociatedSearchHandler() {
        return this.searcherHandlerFactory.createHandler(this);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"number", (String)this.getId());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)WorkRatio.getWorkRatio((Issue)issue)));
    }
}

