/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import webwork.action.Action;

public abstract class AbstractTextSystemField
extends AbstractOrderableNavigableFieldImpl
implements RenderableField,
RestAwareField {
    private static final Logger log = Logger.getLogger(AbstractTextSystemField.class);
    private RendererManager rendererManager;

    public AbstractTextSystemField(String id, String name, VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, RendererManager rendererManager, PermissionManager permissionManager, SearchHandlerFactory searchHandlerFactory) {
        super(id, name, velocityManager, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.rendererManager = rendererManager;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map dispayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, dispayParameters);
    }

    protected abstract String getEditTemplateName();

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        this.populateVelocityParams(fieldLayoutItem, issue, velocityParams);
        return this.renderTemplate(this.getColumnViewTemplateName(), velocityParams);
    }

    protected abstract String getColumnViewTemplateName();

    protected void populateVelocityParams(Map fieldValuesHolder, Map params) {
        if (this.isRenderable()) {
            params.put("rendererParams", new HashMap());
        }
        params.put(this.getId(), fieldValuesHolder.get(this.getId()));
    }

    protected void populateVelocityParams(FieldLayoutItem fieldLayoutItem, Issue issue, Map params) {
        params.put("fieldLayoutItem", fieldLayoutItem);
        params.put("rendererManager", this.rendererManager);
        params.put("issue", issue);
        params.put(this.getId(), this.getValueFromIssue(issue));
    }

    public Object getValueFromParams(Map params) {
        return params.get(this.getId());
    }

    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        fieldValuesHolder.put(this.getId(), stringValue);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        this.populateVelocityParams(operationContext.getFieldValuesHolder(), velocityParams);
        if (this.isRenderable()) {
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            velocityParams.put("rendererDescriptor", this.rendererManager.getRendererForType(rendererType).getDescriptor());
        }
        return this.renderTemplate(this.getEditTemplateName(), velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        if (this.isRenderable()) {
            velocityParams.put("value", this.rendererManager.getRenderedContent(fieldLayoutItem, issue));
        } else {
            velocityParams.put("value", this.getValueFromIssue(issue));
        }
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        if (this.isRenderable()) {
            IssueRenderContext context = issue != null ? issue.getIssueRenderContext() : new IssueRenderContext(null);
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            velocityParams.put("value", this.rendererManager.getRenderedContent(rendererType, (String)value, context));
        } else {
            velocityParams.put("value", value);
        }
        return this.getViewHtml(velocityParams);
    }

    private String getViewHtml(Map velocityParams) {
        velocityParams.put("invertedCollapsedState", this.isInvertCollapsedState());
        return this.renderTemplate("textfield-view.vm", velocityParams);
    }

    protected boolean isInvertCollapsedState() {
        return false;
    }

    public void createValue(Issue issue, Object value) {
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        String value;
        String currentValue = modifiedValue.getOldValue() == null ? null : modifiedValue.getOldValue().toString();
        String string = value = modifiedValue.getNewValue() == null ? null : modifiedValue.getNewValue().toString();
        if (!this.valuesEqual(currentValue, value)) {
            ChangeItemBean cib = new ChangeItemBean("jira", this.getChangeLogFieldName(), null, this.getChangelogValue(currentValue), null, this.getChangelogValue(value));
            issueChangeHolder.addChangeItem(cib);
        }
    }

    protected boolean valuesEqual(String currentValue, String value) {
        return StringUtils.equalsIgnoreLineTerminators((String)currentValue, (String)value);
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Issue originalIssue : originalIssues) {
            String targetRendererType;
            String rendererType;
            if (targetFieldLayoutItem != null && targetFieldLayoutItem.isRequired() && !this.hasValue(originalIssue)) {
                return new MessagedResult(true);
            }
            if (!this.isRenderable() || !this.hasValue(originalIssue)) continue;
            FieldLayoutItem fieldLayoutItem = null;
            try {
                fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(originalIssue.getProjectObject(), originalIssue.getIssueTypeObject().getId()).getFieldLayoutItem(this.getId());
            }
            catch (DataAccessException e) {
                log.warn((Object)(this.getName() + " field was unable to resolve the field layout item for issue " + originalIssue.getId()), (Throwable)e);
            }
            if (this.rendererTypesEqual(rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null, targetRendererType = targetFieldLayoutItem != null ? targetFieldLayoutItem.getRendererType() : null)) continue;
            if (originalIssues.size() > 1) {
                return new MessagedResult(false, this.getAuthenticationContext().getI18nHelper().getText("renderer.bulk.move.warning"), 1);
            }
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        fieldValuesHolder.put(this.getId(), this.getValueFromIssue(originalIssue));
    }

    public boolean hasValue(Issue issue) {
        return TextUtils.stringSet((String)this.getValueFromIssue(issue));
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), this.getValueFromIssue(issue));
    }

    public abstract String getValueFromIssue(Issue var1);

    public boolean isRenderable() {
        return true;
    }

    protected String getChangeLogFieldName() {
        return this.getId();
    }

    protected String getChangelogValue(Object value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        return (String)value;
    }

    @Override
    protected Object getRelevantParams(Map params) {
        String[] value = (String[])params.get(this.getId());
        if (value != null && value.length > 0) {
            return value[0];
        }
        return null;
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), "");
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"string", (String)this.getId());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        FieldJsonRepresentation fieldJsonRepresentation = new FieldJsonRepresentation(new JsonData((Object)this.getValueFromIssue(issue)));
        if (renderedVersionRequired && this.isRenderable() && fieldLayoutItem != null && org.apache.commons.lang.StringUtils.isNotBlank((String)fieldLayoutItem.getRendererType())) {
            fieldJsonRepresentation.setRenderedData(new JsonData((Object)this.rendererManager.getRenderedContent(fieldLayoutItem, issue)));
        }
        return fieldJsonRepresentation;
    }
}

