/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.converters.DateConverter;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.DateCustomFieldSearchRenderer;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.DateCustomFieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.DateSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.issue.statistics.DateFieldSorter;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.DateClauseQueryFactory;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.DateValidator;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.atlassian.jira.web.bean.FieldVisibilityBean;
import com.atlassian.velocity.VelocityManager;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractDateRangeSearcher
extends AbstractInitializationCustomFieldSearcher
implements SortableCustomFieldSearcher,
CustomFieldSearcher {
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    final JqlOperandResolver jqlOperandResolver;
    private final TimeZoneManager timeZoneManager;
    final FieldVisibilityManager fieldVisibilityManager;
    final VelocityRequestContextFactory velocityRenderContext;
    final ApplicationProperties applicationProperties;
    final VelocityManager velocityManager;
    final CalendarLanguageUtil calendarUtils;
    final DateConverter dateConverter;
    final JqlDateSupport dateSupport;

    public AbstractDateRangeSearcher(JqlOperandResolver jqlOperandResolver, VelocityRequestContextFactory velocityRenderContext, ApplicationProperties applicationProperties, VelocityManager velocityManager, CalendarLanguageUtil calendarUtils, DateConverter dateConverter, JqlDateSupport dateSupport, TimeZoneManager timeZoneManager) {
        this.jqlOperandResolver = jqlOperandResolver;
        this.timeZoneManager = timeZoneManager;
        this.fieldVisibilityManager = new FieldVisibilityBean();
        this.velocityRenderContext = velocityRenderContext;
        this.applicationProperties = applicationProperties;
        this.velocityManager = velocityManager;
        this.calendarUtils = calendarUtils;
        this.dateConverter = dateConverter;
        this.dateSupport = dateSupport;
    }

    public void init(CustomField field) {
        ClauseNames names = field.getClauseNames();
        Set supportedOperators = OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY;
        SimpleFieldSearchConstants constants = new SimpleFieldSearchConstants(field.getId(), names, field.getId(), field.getId(), field.getId(), supportedOperators, JiraDataTypes.DATE);
        DateCustomFieldIndexer indexer = new DateCustomFieldIndexer(this.fieldVisibilityManager, field);
        String nameKey = "navigator.filter." + field.getId();
        DateSearcherConfig config = new DateSearcherConfig(field.getId(), names, field.getName());
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchInputTransformer = this.createSearchInputTransformer(config, this.timeZoneManager);
        this.searchRenderer = this.createSearchRenderer(field, constants, nameKey, config);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldSearcherClauseHandler((ClauseValidator)new DateValidator(this.jqlOperandResolver, this.timeZoneManager), (ClauseQueryFactory)new DateClauseQueryFactory(constants, this.dateSupport, this.jqlOperandResolver), supportedOperators, JiraDataTypes.DATE);
    }

    abstract DateSearchInputTransformer createSearchInputTransformer(DateSearcherConfig var1, TimeZoneManager var2);

    abstract DateCustomFieldSearchRenderer createSearchRenderer(CustomField var1, SimpleFieldSearchConstants var2, String var3, DateSearcherConfig var4);

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    public LuceneFieldSorter getSorter(CustomField customField) {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve Sorter off uninitialised custom field searcher.");
        }
        return new DateFieldSorter(this.searcherInformation.getId());
    }
}

