/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultChangeHistoryManager
implements ChangeHistoryManager {
    private static final Logger log = Logger.getLogger(DefaultChangeHistoryManager.class);
    private final IssueManager issueManager;
    private final OfBizDelegator ofBizDelegator;
    private final PermissionManager permissionManager;
    private final ComponentLocator componentLocator;
    private static final String FIELD_KEY = "Key";
    private static final String ISSUEID_FIELD = "issueid";
    private static final List<String> FIELDS_TO_SELECT = ImmutableList.of((Object)"issueid");

    public DefaultChangeHistoryManager(IssueManager issueManager, OfBizDelegator ofBizDelegator, PermissionManager permissionManager, ComponentLocator componentLocator) {
        this.issueManager = issueManager;
        this.ofBizDelegator = ofBizDelegator;
        this.permissionManager = permissionManager;
        this.componentLocator = componentLocator;
    }

    public List<ChangeHistory> getChangeHistories(Issue issue) {
        return this.getAllChangeHistories(issue);
    }

    public List<ChangeHistory> getChangeHistoriesForUser(Issue issue, User remoteUser) {
        return this.getAllChangeHistories(issue);
    }

    private List<ChangeHistory> getAllChangeHistories(Issue issue) {
        Assertions.notNull((String)"issue", (Object)issue);
        if (issue.getId() == null) {
            return Collections.emptyList();
        }
        List allChangeGroups = this.ofBizDelegator.findByAnd("ChangeGroup", (Map)ImmutableMap.of((Object)"issue", (Object)issue.getId()), (List)ImmutableList.of((Object)"created ASC", (Object)"id ASC"));
        return Lists.transform((List)allChangeGroups, (Function)new Function<GenericValue, ChangeHistory>(){

            public ChangeHistory apply(@Nullable GenericValue changeHistoryGroupAsGv) {
                return new ChangeHistory(changeHistoryGroupAsGv, DefaultChangeHistoryManager.this.issueManager);
            }
        });
    }

    public List<ChangeItemBean> getChangeItemsForField(Issue issue, String changeItemFieldName) {
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notBlank((String)"changeItemFieldName", (String)changeItemFieldName);
        if (issue.getId() == null) {
            return Collections.emptyList();
        }
        List changeItemsForFieldGVs = this.ofBizDelegator.findByAnd("ChangeGroupChangeItemView", (Map)ImmutableMap.of((Object)"issue", (Object)issue.getId(), (Object)"field", (Object)changeItemFieldName), (List)ImmutableList.of((Object)"created ASC", (Object)"changeitemid ASC"));
        ArrayList<ChangeItemBean> changeItemsForField = new ArrayList<ChangeItemBean>();
        for (GenericValue changeItemGV : changeItemsForFieldGVs) {
            changeItemsForField.add(new ChangeItemBean(changeItemGV.getString("fieldtype"), changeItemGV.getString("field"), changeItemGV.getString("oldvalue"), changeItemGV.getString("oldstring"), changeItemGV.getString("newvalue"), changeItemGV.getString("newstring"), changeItemGV.getTimestamp("created")));
        }
        return changeItemsForField;
    }

    public List<ChangeHistoryItem> getAllChangeItems(Issue issue) {
        Assertions.notNull((String)"issue", (Object)issue);
        if (issue.getId() == null) {
            return Collections.emptyList();
        }
        List changeItemsGVs = this.ofBizDelegator.findByAnd("ChangeGroupChangeItemView", (Map)ImmutableMap.of((Object)"issue", (Object)issue.getId()), (List)ImmutableList.of((Object)"created ASC", (Object)"changeitemid ASC"));
        HashMap fieldsPerChangeGroup = Maps.newHashMap();
        ArrayList builders = Lists.newArrayList();
        for (GenericValue changeItemGV : changeItemsGVs) {
            ChangeHistoryItem.Builder builder;
            Long changeGroupId = changeItemGV.getLong("changegroupid");
            String fieldName = changeItemGV.getString("field");
            HashMap<String, ChangeHistoryItem.Builder> buildersPerField = (HashMap<String, ChangeHistoryItem.Builder>)fieldsPerChangeGroup.get(changeGroupId);
            if (buildersPerField == null) {
                buildersPerField = new HashMap<String, ChangeHistoryItem.Builder>();
                fieldsPerChangeGroup.put(changeGroupId, buildersPerField);
            }
            if (buildersPerField.containsKey(fieldName)) {
                builder = (ChangeHistoryItem.Builder)buildersPerField.get(fieldName);
                builder.changedFrom(changeItemGV.getString("oldstring"), changeItemGV.getString("oldvalue"));
                builder.to(changeItemGV.getString("newstring"), changeItemGV.getString("newvalue"));
                continue;
            }
            builder = new ChangeHistoryItem.Builder().withId(changeItemGV.getLong("changeitemid").longValue()).inChangeGroup(changeGroupId.longValue()).inProject(issue.getProjectObject().getId().longValue()).forIssue(issue.getId().longValue(), issue.getKey()).field(changeItemGV.getString("field")).on(changeItemGV.getTimestamp("created")).changedFrom(changeItemGV.getString("oldstring"), changeItemGV.getString("oldvalue")).to(changeItemGV.getString("newstring"), changeItemGV.getString("newvalue")).byUser(changeItemGV.getString("author"));
            buildersPerField.put(fieldName, builder);
            builders.add(builder);
        }
        return Lists.transform((List)builders, (Function)new Function<ChangeHistoryItem.Builder, ChangeHistoryItem>(){

            public ChangeHistoryItem apply(@Nullable ChangeHistoryItem.Builder builder) {
                return builder.build();
            }
        });
    }

    public Issue findMovedIssue(String originalKey) throws GenericEntityException {
        GenericValue changeItem;
        String key = originalKey.toUpperCase();
        try {
            List changeItems = this.ofBizDelegator.findByLike("ChangeItem", (Map)ImmutableMap.of((Object)"field", (Object)FIELD_KEY, (Object)"oldstring", (Object)key), (List)ImmutableList.of((Object)"group desc"));
            changeItem = this.getLastChangeItem(changeItems);
        }
        catch (DataAccessException e) {
            return null;
        }
        if (changeItem == null) {
            return null;
        }
        GenericValue changeGroup = this.ofBizDelegator.findByPrimaryKey("ChangeGroup", (Map)ImmutableMap.of((Object)"id", (Object)changeItem.getLong("group")));
        if (changeGroup == null) {
            return null;
        }
        return this.issueManager.getIssueObject(changeGroup.getLong("issue"));
    }

    public Collection<String> getPreviousIssueKeys(Long issueId) {
        Null.not("issueId", issueId);
        try {
            EntityFieldMap condition = new EntityFieldMap((Map)ImmutableMap.of((Object)"issue", (Object)issueId, (Object)"field", (Object)FIELD_KEY), EntityOperator.AND);
            List gvs = this.ofBizDelegator.findByCondition("ChangeGroupChangeItemView", (EntityCondition)condition, (Collection)ImmutableList.of((Object)"group", (Object)"oldstring", (Object)"newstring"), (List)ImmutableList.of((Object)"group desc"));
            return this.collectPreviousIssueKeys(gvs);
        }
        catch (DataAccessException e) {
            return Collections.emptySet();
        }
    }

    public Collection<String> getPreviousIssueKeys(String issueKey) {
        Null.not("issueKey", issueKey);
        MutableIssue theIssue = this.issueManager.getIssueObject(issueKey);
        if (theIssue == null) {
            return Collections.emptySet();
        }
        return this.getPreviousIssueKeys(theIssue.getId());
    }

    public Collection<Issue> findUserHistory(User remoteUser, Collection<String> usernames, int maxResults) {
        ArrayList<Long> projectIds = new ArrayList<Long>();
        for (Project project : this.permissionManager.getProjectObjects(10, remoteUser)) {
            projectIds.add(project.getId());
        }
        return this.doFindUserHistory(remoteUser, usernames, projectIds, maxResults);
    }

    public Collection<Issue> findUserHistory(User remoteUser, Collection<String> usernames, Collection<Project> projects, int maxResults) {
        ArrayList<Long> filteredProjectIds = new ArrayList<Long>();
        for (Project project : projects) {
            if (!this.permissionManager.hasPermission(10, project, remoteUser)) continue;
            filteredProjectIds.add(project.getId());
        }
        return this.doFindUserHistory(remoteUser, usernames, filteredProjectIds, maxResults);
    }

    public Map<String, String> findAllPossibleValues(String field) {
        Null.not("field", field);
        List<GenericValue> gvs = this.getAllChangeItems(field);
        return this.collectFieldValues(gvs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GenericValue> getAllChangeItems(String field) {
        OfBizListIterator iterator = null;
        EntityFieldMap condition = new EntityFieldMap((Map)ImmutableMap.of((Object)"field", (Object)field), EntityOperator.AND);
        try {
            iterator = this.ofBizDelegator.findListIteratorByCondition("ChangeItem", (EntityCondition)condition, null, (Collection)ImmutableList.of((Object)"oldstring", (Object)"oldvalue", (Object)"newstring", (Object)"newvalue"), (List)ImmutableList.of((Object)"asc"), null);
            List list = iterator.getCompleteList();
            return list;
        }
        catch (DataAccessException e) {
            log.error((Object)("Unable to retrieve values for " + field), (Throwable)e);
            ArrayList arrayList = Lists.newArrayList();
            return arrayList;
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    public void removeAllChangeItems(Issue issue) {
        ImmutableMap params = ImmutableMap.of((Object)"issue", (Object)issue.getId());
        List changeGroups = this.ofBizDelegator.findByAnd("ChangeGroup", (Map)params);
        for (GenericValue changeGroup : changeGroups) {
            this.ofBizDelegator.removeByAnd("ChangeItem", (Map)ImmutableMap.of((Object)"group", (Object)changeGroup.getLong("id")));
        }
        this.ofBizDelegator.removeByAnd("ChangeGroup", (Map)params);
    }

    private Map<String, String> collectFieldValues(List<GenericValue> genericValues) {
        MapBuilder builder = MapBuilder.newBuilder();
        for (GenericValue gv : genericValues) {
            if (StringUtils.isNotBlank((String)gv.getString("oldstring")) && StringUtils.isNotBlank((String)gv.getString("oldvalue"))) {
                builder.add((Object)gv.getString("oldstring").toLowerCase(), (Object)gv.getString("oldvalue").toLowerCase());
            }
            if (!StringUtils.isNotBlank((String)gv.getString("newstring")) || !StringUtils.isNotBlank((String)gv.getString("newvalue"))) continue;
            builder.add((Object)gv.getString("newstring").toLowerCase(), (Object)gv.getString("newvalue").toLowerCase());
        }
        return builder.toMap();
    }

    Collection<Issue> doFindUserHistory(User remoteUser, Collection<String> usernames, Collection<Long> projects, int maxResults) {
        if (projects.isEmpty()) {
            return Collections.emptyList();
        }
        EntityConditionList entityCondition = new EntityConditionList(Arrays.asList(new EntityExpr("project", EntityOperator.IN, projects), new EntityExpr("author", EntityOperator.IN, usernames)), EntityOperator.AND);
        LinkedHashSet<Long> issueIds = new LinkedHashSet<Long>();
        issueIds.addAll(this.extractIssueIds(maxResults, this.ofBizDelegator.findListIteratorByCondition("ChangeGroupIssueView", (EntityCondition)entityCondition, null, FIELDS_TO_SELECT, (List)ImmutableList.of((Object)"created DESC"), null)));
        issueIds.addAll(this.extractIssueIds(maxResults, this.ofBizDelegator.findListIteratorByCondition("ActionIssueView", (EntityCondition)entityCondition, null, FIELDS_TO_SELECT, (List)ImmutableList.of((Object)"created DESC"), null)));
        if (!issueIds.isEmpty()) {
            SearchResults searchResults;
            JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().defaultAnd();
            builder.issue().in(issueIds.toArray(new Long[issueIds.size()])).endWhere().orderBy().createdDate(SortOrder.DESC);
            Query query = builder.buildQuery();
            SearchProvider searchProvider = (SearchProvider)this.componentLocator.getComponentInstanceOfType(SearchProvider.class);
            try {
                searchResults = searchProvider.search(query, remoteUser, PagerFilter.getUnlimitedFilter());
            }
            catch (SearchException e) {
                log.error((Object)("Error running query '" + query + "'"));
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(searchResults.getIssues());
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> extractIssueIds(int maxResults, OfBizListIterator iterator) {
        try {
            LinkedHashSet<Long> issueIds = new LinkedHashSet<Long>();
            GenericValue issueIdGV = iterator.next();
            for (int issuesLeft = maxResults; issueIdGV != null && issuesLeft > 0; --issuesLeft) {
                issueIds.add(issueIdGV.getLong(ISSUEID_FIELD));
                issueIdGV = iterator.next();
            }
            LinkedHashSet<Long> linkedHashSet = issueIds;
            return linkedHashSet;
        }
        finally {
            iterator.close();
        }
    }

    private Collection<String> collectPreviousIssueKeys(List<GenericValue> issueChangeItemIteratorGVs) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (GenericValue issueChangeItemIteratorGV : issueChangeItemIteratorGVs) {
            String oldString = issueChangeItemIteratorGV.getString("oldstring");
            if (!StringUtils.isNotEmpty((String)oldString)) continue;
            result.add(oldString);
        }
        return result;
    }

    private GenericValue getLastChangeItem(List<GenericValue> changeItems) {
        GenericValue lastChangeItem = null;
        for (GenericValue changeItem : changeItems) {
            if (lastChangeItem != null && lastChangeItem.getLong("id").compareTo(changeItem.getLong("id")) >= 0) continue;
            lastChangeItem = changeItem;
        }
        return lastChangeItem;
    }
}

