/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class AttachmentZipFileCreator {
    private final Issue issue;

    public AttachmentZipFileCreator(Issue issue) {
        this.issue = issue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File toZipFile() throws IOException {
        File zipFile = File.createTempFile(this.issue.getKey() + "-", ".zip");
        Collection attachments = this.issue.getAttachments();
        UniqueFileNameGenerator uniqueFileNameGenerator = new UniqueFileNameGenerator();
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zipFile));
            for (Attachment attachment : attachments) {
                File attachmentFile = this.getAttachmentFile(attachment);
                String attachmentFileName = attachment.getFilename();
                ZipEntry zipEntry = new ZipEntry(uniqueFileNameGenerator.getUniqueFileName(attachmentFileName));
                out.putNextEntry(zipEntry);
                FileInputStream in = null;
                try {
                    in = new FileInputStream(attachmentFile);
                    IOUtil.copy((InputStream)in, (OutputStream)out);
                    out.closeEntry();
                }
                catch (Throwable throwable) {
                    IOUtil.shutdownStream(in);
                    throw throwable;
                }
                IOUtil.shutdownStream(in);
            }
        }
        catch (Throwable throwable) {
            IOUtil.shutdownStream(out);
            throw throwable;
        }
        IOUtil.shutdownStream(out);
        return zipFile;
    }

    File getAttachmentFile(Attachment attachment) {
        return AttachmentUtils.getAttachmentFile((Attachment)attachment);
    }

    static class UniqueFileNameGenerator {
        private static final Pattern pattern = Pattern.compile("\\.([0-9]+)$");
        private Set<String> fileNamesSet = new HashSet<String>();

        UniqueFileNameGenerator() {
        }

        public String getUniqueFileName(String fileName) {
            String safeFileName = fileName;
            while (this.fileNamesSet.contains(safeFileName)) {
                safeFileName = this.mungeFileName(safeFileName);
            }
            this.fileNamesSet.add(safeFileName);
            return safeFileName;
        }

        private String mungeFileName(String fileName) {
            Matcher m = pattern.matcher(fileName);
            if (m.find()) {
                String numberStr = m.group(m.groupCount());
                int number = Integer.parseInt(numberStr, 10) + 1;
                return m.replaceFirst("." + number);
            }
            return fileName + ".1";
        }
    }
}

