/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.instrumentation.AbsoluteCounter;
import com.atlassian.instrumentation.Counter;
import com.atlassian.instrumentation.DerivedCounter;
import com.atlassian.instrumentation.Gauge;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.instrumentation.InstrumentRegistry;
import com.atlassian.instrumentation.operations.OpCounter;
import com.atlassian.instrumentation.operations.OpSnapshot;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.instrumentation.operations.OpTimerFactory;
import com.atlassian.instrumentation.operations.ThreadLocalOpTimerFactory;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.instrumentation.external.ExternalGauges;
import java.util.List;

public class Instrumentation
implements Startable {
    private static InstrumentRegistry getTenantedInstance() {
        return (InstrumentRegistry)ComponentAccessor.getComponent(InstrumentRegistry.class);
    }

    public static Instrument putInstrument(Instrument instrument) {
        return Instrumentation.getTenantedInstance().putInstrument(instrument);
    }

    public static Instrument getInstrument(String name) {
        return Instrumentation.getTenantedInstance().getInstrument(name);
    }

    public static AbsoluteCounter pullAbsoluteCounter(String name) {
        return Instrumentation.getTenantedInstance().pullAbsoluteCounter(name);
    }

    public static AbsoluteCounter pullAbsoluteCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullAbsoluteCounter(instrumentationName.getInstrumentName());
    }

    public static Counter pullCounter(String name) {
        return Instrumentation.getTenantedInstance().pullCounter(name);
    }

    public static Counter pullCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullCounter(instrumentationName.getInstrumentName());
    }

    public static DerivedCounter pullDerivedCounter(String name) {
        return Instrumentation.getTenantedInstance().pullDerivedCounter(name);
    }

    public static DerivedCounter pullDerivedCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullDerivedCounter(instrumentationName.getInstrumentName());
    }

    public static Gauge pullGauge(String name) {
        return Instrumentation.getTenantedInstance().pullGauge(name);
    }

    public static Gauge pullGauge(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullGauge(instrumentationName.getInstrumentName());
    }

    public static OpCounter pullOpCounter(String name) {
        return Instrumentation.getTenantedInstance().pullOpCounter(name);
    }

    public static OpCounter pullOpCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullOpCounter(instrumentationName.getInstrumentName());
    }

    public static OpTimer pullTimer(String name) {
        return Instrumentation.getTenantedInstance().pullTimer(name);
    }

    public static OpTimer pullTimer(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullTimer(instrumentationName.getInstrumentName());
    }

    public static List<Instrument> snapshotInstruments() {
        return Instrumentation.getTenantedInstance().snapshotInstruments();
    }

    public static List<OpSnapshot> snapshotThreadLocalOperationsAndClear() {
        OpTimerFactory opTimerFactory = ComponentManager.getComponent(OpTimerFactory.class);
        if (opTimerFactory instanceof ThreadLocalOpTimerFactory) {
            ThreadLocalOpTimerFactory threadLocalOpTimerFactory = (ThreadLocalOpTimerFactory)opTimerFactory;
            return threadLocalOpTimerFactory.snapshotAndClear();
        }
        throw new IllegalStateException("We really expect the implementation of OpTimerFactory to in fact be a ThreadLocalOpTimerFactory");
    }

    public void start() {
        new ExternalGauges();
        Instrumentation.pullOpCounter(InstrumentationName.WEB_REQUESTS);
        Instrumentation.pullOpCounter(InstrumentationName.DB_READS);
        Instrumentation.pullOpCounter(InstrumentationName.DB_WRITES);
        Instrumentation.pullOpCounter(InstrumentationName.ISSUE_INDEX_READS);
        Instrumentation.pullOpCounter(InstrumentationName.ISSUE_INDEX_WRITES);
    }
}

