/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalVoter;
import com.atlassian.jira.external.beans.ExternalWatcher;
import com.atlassian.jira.imports.project.parser.UserAssociationParser;
import com.atlassian.jira.util.dbc.Null;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class UserAssociationParserImpl
implements UserAssociationParser {
    private static final String ASSOCIATION_TYPE = "associationType";
    private static final String SINK_NODE_ENTITY = "sinkNodeEntity";
    private static final String SINK_NODE_ID = "sinkNodeId";
    private static final String SOURCE_NAME = "sourceName";

    @Override
    public ExternalVoter parseVoter(Map attributes) throws ParseException {
        Null.not("attributes", attributes);
        String sinkNodeEntity = (String)attributes.get(SINK_NODE_ENTITY);
        String associationType = (String)attributes.get(ASSOCIATION_TYPE);
        if (!"Issue".equals(sinkNodeEntity) || !"VoteIssue".equals(associationType)) {
            return null;
        }
        String issueId = (String)attributes.get(SINK_NODE_ID);
        String voter = (String)attributes.get(SOURCE_NAME);
        if (StringUtils.isBlank((String)issueId)) {
            throw new ParseException("A voter must have an associated issue id.");
        }
        if (StringUtils.isBlank((String)voter)) {
            throw new ParseException("Voter associated with issue id '" + issueId + "' has no user associated with the vote.");
        }
        ExternalVoter externalVoter = new ExternalVoter();
        externalVoter.setIssueId(issueId);
        externalVoter.setVoter(voter);
        return externalVoter;
    }

    @Override
    public ExternalWatcher parseWatcher(Map attributes) throws ParseException {
        Null.not("attributes", attributes);
        String sinkNodeEntity = (String)attributes.get(SINK_NODE_ENTITY);
        String associationType = (String)attributes.get(ASSOCIATION_TYPE);
        if (!"Issue".equals(sinkNodeEntity) || !"WatchIssue".equals(associationType)) {
            return null;
        }
        String issueId = (String)attributes.get(SINK_NODE_ID);
        String watcher = (String)attributes.get(SOURCE_NAME);
        if (StringUtils.isBlank((String)issueId)) {
            throw new ParseException("A watcher must have an associated issue id.");
        }
        if (StringUtils.isBlank((String)watcher)) {
            throw new ParseException("Watcher associated with issue id '" + issueId + "' has no user associated with the watch.");
        }
        ExternalWatcher externalWatcher = new ExternalWatcher();
        externalWatcher.setIssueId(issueId);
        externalWatcher.setWatcher(watcher);
        return externalWatcher;
    }
}

