/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalLink;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.EntityRepresentationImpl;
import com.atlassian.jira.imports.project.parser.IssueLinkParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class IssueLinkParserImpl
implements IssueLinkParser {
    private static final String ID = "id";
    private static final String LINK_TYPE = "linktype";
    private static final String SOURCE = "source";
    private static final String DESTINATION = "destination";
    private static final String SEQUENCE = "sequence";

    @Override
    public ExternalLink parse(Map attributes) throws ParseException {
        if (attributes == null) {
            throw new IllegalArgumentException("The 'attributes' parameter cannot be null.");
        }
        String id = (String)attributes.get(ID);
        String linktype = (String)attributes.get(LINK_TYPE);
        String source = (String)attributes.get(SOURCE);
        String destination = (String)attributes.get(DESTINATION);
        String sequence = (String)attributes.get(SEQUENCE);
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("No 'id' field for IssueLink.");
        }
        if (StringUtils.isEmpty((String)linktype)) {
            throw new ParseException("No 'linktype' field for IssueLink " + id + ".");
        }
        ExternalLink externalLink = new ExternalLink();
        externalLink.setId(id);
        externalLink.setLinkType(linktype);
        externalLink.setSourceId(source);
        externalLink.setDestinationId(destination);
        externalLink.setSequence(sequence);
        return externalLink;
    }

    @Override
    public EntityRepresentation getEntityRepresentation(ExternalLink issueLink) {
        HashMap<String, String> entityValues = new HashMap<String, String>(5);
        entityValues.put(ID, issueLink.getId());
        entityValues.put(LINK_TYPE, issueLink.getLinkType());
        entityValues.put(SOURCE, issueLink.getSourceId());
        entityValues.put(DESTINATION, issueLink.getDestinationId());
        entityValues.put(SEQUENCE, issueLink.getSequence());
        return new EntityRepresentationImpl("IssueLink", entityValues);
    }
}

