/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.parser.NodeAssociationParser;
import com.atlassian.jira.imports.project.parser.NodeAssociationParserImpl;
import java.util.Map;

public class IssueVersionMapperHandler
implements ImportEntityHandler {
    private NodeAssociationParser nodeAssocationParser;
    private final SimpleProjectImportIdMapper versionMapper;
    private final BackupProject backupProject;

    public IssueVersionMapperHandler(BackupProject backupProject, SimpleProjectImportIdMapper versionMapper) {
        this.backupProject = backupProject;
        this.versionMapper = versionMapper;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        ExternalNodeAssociation nodeAssociation;
        if ("NodeAssociation".equals(entityName) && ("IssueVersion".equals((nodeAssociation = this.getNodeAssociationParser().parse(attributes)).getAssociationType()) || "IssueFixVersion".equals(nodeAssociation.getAssociationType())) && this.backupProject.containsIssue(nodeAssociation.getSourceNodeId())) {
            this.versionMapper.flagValueAsRequired(nodeAssociation.getSinkNodeId());
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    NodeAssociationParser getNodeAssociationParser() {
        if (this.nodeAssocationParser == null) {
            this.nodeAssocationParser = new NodeAssociationParserImpl();
        }
        return this.nodeAssocationParser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueVersionMapperHandler that = (IssueVersionMapperHandler)o;
        if (this.backupProject != null ? !this.backupProject.equals(that.backupProject) : that.backupProject != null) {
            return false;
        }
        if (this.nodeAssocationParser != null ? !this.nodeAssocationParser.equals(that.nodeAssocationParser) : that.nodeAssocationParser != null) {
            return false;
        }
        return !(this.versionMapper != null ? !this.versionMapper.equals(that.versionMapper) : that.versionMapper != null);
    }

    public int hashCode() {
        int result = this.nodeAssocationParser != null ? this.nodeAssocationParser.hashCode() : 0;
        result = 31 * result + (this.versionMapper != null ? this.versionMapper.hashCode() : 0);
        result = 31 * result + (this.backupProject != null ? this.backupProject.hashCode() : 0);
        return result;
    }
}

