/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import org.apache.log4j.Logger;

public final class JiraSystemProperties {
    private JiraSystemProperties() {
    }

    public static boolean isXsrfDetectionCheckRequired() {
        return Boolean.getBoolean("xsrf.detection.check");
    }

    public static boolean isDevMode() {
        return Boolean.getBoolean("jira.dev.mode") || Boolean.getBoolean("atlassian.dev.mode");
    }

    public static boolean isBundledPluginsDisabled() {
        return Boolean.getBoolean("jira.plugins.bundled.disable");
    }

    public static boolean isI18nReloadBundles() {
        return Boolean.getBoolean("jira.i18n.reloadbundles");
    }

    public static boolean isDecodeMailParameters() {
        return JiraSystemProperties.getBooleanSafely("mail.mime.decodeparameters", false);
    }

    public static boolean isDecodeMailFileName() {
        return JiraSystemProperties.getBooleanSafely("mail.mime.decodefilename", false);
    }

    public static boolean isSuperBatchingDisabled() {
        return JiraSystemProperties.getBooleanSafely("jira.superbatching.disabled", false);
    }

    public static boolean isWebSudoDisabled() {
        return JiraSystemProperties.getBooleanSafely("jira.websudo.is.disabled", false);
    }

    public static boolean showPerformanceMonitor() {
        return JiraSystemProperties.getBooleanSafely("jira.show.perf.monitor", false);
    }

    private static boolean getBooleanSafely(String property, boolean defValue) {
        try {
            String value = System.getProperty(property);
            if (value == null) {
                return defValue;
            }
            return Boolean.parseBoolean(value);
        }
        catch (SecurityException e) {
            JiraSystemProperties.getLogger().warn((Object)("Unable to read system property '" + property + "'. Return default value of '" + defValue + "'."), (Throwable)e);
            return defValue;
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(JiraSystemProperties.class);
    }
}

