/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.Connection;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.JndiDatasourceInfo;

public final class JndiDatasource
implements Datasource {
    private final String jndiName;

    public JndiDatasource(String jndiName) {
        this.jndiName = Assertions.notBlank((String)"JNDI name", (String)jndiName);
    }

    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public Connection getConnection(AtlassianBootstrapManager bootstrapManager) throws BootstrapException {
        return bootstrapManager.getTestDatasourceConnection(this.jndiName);
    }

    @Override
    public DatasourceInfo getDatasource(String datasourceName, String databaseType, String schemaName) {
        JndiDatasourceInfo jndiInfo = new JndiDatasourceInfo(this.jndiName, "default");
        return new DatasourceInfo(datasourceName, databaseType, schemaName, jndiInfo);
    }

    @Override
    public String getDescriptorValue(String databaseType) {
        return databaseType + " " + this.jndiName;
    }

    @Override
    public String getDescriptorLabel() {
        return "Database JNDI config";
    }
}

