/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.DatabaseConfig;
import com.atlassian.jira.configurator.db.DatabaseConfigFactory;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.Connection;
import java.util.Properties;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;

public final class JdbcDatasource
implements Datasource {
    private static final long POOL_DEFAULTS_MAX_WAIT = 60000L;
    private static final int POOL_DEFAULTS_MIN_SIZE = 2;
    private static final int POOL_DEFAULTS_SLEEP_TIME = 300000;
    private static final int POOL_DEFAULTS_LIFE_TIME = 600000;
    private static final int POOL_DEFAULTS_DEAD_LOCK_MAX_WAIT = 600000;
    private static final int POOL_DEFAULTS_DEAD_LOCK_RETRY_WAIT = 10000;
    private final String jdbcUrl;
    private final String driverClassName;
    private final String username;
    private final String password;
    private final Properties connectionProperties;
    private final int poolSize;
    private final String validationQuery;
    private final Long minEvictableTimeMillis;
    private final Long timeBetweenEvictionRunsMillis;
    private static boolean registerDriverOnConstruct = true;

    public JdbcDatasource(String jdbcUrl, String driverClassName, String username, String password, int poolSize, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        this.jdbcUrl = Assertions.notBlank((String)"JDBC URL", (String)jdbcUrl);
        this.driverClassName = Assertions.notBlank((String)"Driver class name", (String)driverClassName);
        this.username = Assertions.notBlank((String)"username", (String)username);
        this.password = (String)Assertions.notNull((String)"password", (Object)password);
        this.connectionProperties = null;
        Assertions.not((String)"poolSize", (poolSize <= 0 ? 1 : 0) != 0);
        this.poolSize = poolSize;
        this.validationQuery = validationQuery;
        this.minEvictableTimeMillis = minEvictableTimeMillis;
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.registerDriver();
    }

    public JdbcDatasource(String jdbcUrl, String driverClassName, String username, String password, Properties connectionProperties, int poolSize, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        this.jdbcUrl = Assertions.notBlank((String)"JDBC URL", (String)jdbcUrl);
        this.driverClassName = Assertions.notBlank((String)"Driver class name", (String)driverClassName);
        this.username = Assertions.notBlank((String)"username", (String)username);
        this.password = (String)Assertions.notNull((String)"password", (Object)password);
        this.connectionProperties = connectionProperties;
        Assertions.not((String)"poolSize", (poolSize <= 0 ? 1 : 0) != 0);
        this.poolSize = poolSize;
        this.validationQuery = validationQuery;
        this.minEvictableTimeMillis = minEvictableTimeMillis;
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.registerDriver();
    }

    public JdbcDatasource(DatabaseType databaseType, String hostname, String port, String instance, String username, String password, Integer poolSize, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        DatabaseConfig databaseConfig = DatabaseConfigFactory.getDatabaseConfigFor(databaseType);
        try {
            this.jdbcUrl = databaseConfig.getUrl(hostname, port, instance);
        }
        catch (ValidationException ex) {
            throw new IllegalArgumentException(ex);
        }
        this.driverClassName = databaseConfig.getClassName();
        this.username = Assertions.notBlank((String)"username", (String)username);
        this.password = (String)Assertions.notNull((String)"password", (Object)password);
        this.connectionProperties = null;
        Assertions.not((String)"poolSize", (poolSize <= 0 ? 1 : 0) != 0);
        this.poolSize = poolSize;
        this.validationQuery = validationQuery;
        this.minEvictableTimeMillis = minEvictableTimeMillis;
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.registerDriver();
    }

    public static void setRegisterDriverOnConstruct(boolean registerDriverOnConstruct) {
        JdbcDatasource.registerDriverOnConstruct = registerDriverOnConstruct;
    }

    private void registerDriver() {
        if (registerDriverOnConstruct) {
            try {
                Class.forName(this.driverClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("JDBC Driver class '" + this.driverClassName + " could not be loaded.'", ex);
            }
        }
    }

    @Override
    public Connection getConnection(AtlassianBootstrapManager bootstrapManager) throws BootstrapException {
        return bootstrapManager.getTestDatabaseConnection(this.createDbDetails());
    }

    @Override
    public DatasourceInfo getDatasource(String datasourceName, String databaseType, String schemaName) {
        ConnectionPoolInfo poolInfo = new ConnectionPoolInfo(Integer.valueOf(this.poolSize), Integer.valueOf(2), Long.valueOf(60000L), 300000L, 600000L, 600000L, 10000L, this.validationQuery, this.minEvictableTimeMillis, this.timeBetweenEvictionRunsMillis);
        JdbcDatasourceInfo jdbcInfo = new JdbcDatasourceInfo(this.jdbcUrl, this.driverClassName, this.username, this.password, null, this.connectionProperties, poolInfo);
        return new DatasourceInfo(datasourceName, databaseType, schemaName, jdbcInfo);
    }

    @Override
    public String getDescriptorValue(String databaseType) {
        return databaseType + " " + this.jdbcUrl;
    }

    @Override
    public String getDescriptorLabel() {
        return "Database JDBC config";
    }

    DatabaseDetails createDbDetails() {
        DatabaseDetails dbDetails = new DatabaseDetails();
        dbDetails.setDatabaseUrl(this.jdbcUrl);
        dbDetails.setDriverClassName(this.driverClassName);
        dbDetails.setUserName(this.username);
        dbDetails.setPassword(this.password);
        dbDetails.setPoolSize(this.poolSize);
        return dbDetails;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public Long getMinEvictableTimeMillis() {
        return this.minEvictableTimeMillis;
    }

    public Long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }
}

