/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.config.AbstractIssueConstantsManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.StatusImpl;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultStatusManager
extends AbstractIssueConstantsManager<Status>
implements StatusManager {
    private final TranslationManager translationManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowManager workflowManager;
    private static final Long NEW_STATUS_START_ID = 10000L;

    public DefaultStatusManager(ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, IssueIndexManager issueIndexManager, TranslationManager translationManager, JiraAuthenticationContext jiraAuthenticationContext, WorkflowManager workflowManager) {
        super(constantsManager, ofBizDelegator, issueIndexManager);
        this.translationManager = translationManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.workflowManager = workflowManager;
    }

    public synchronized Status createStatus(String name, String description, String iconUrl) {
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notBlank((String)"iconUrl", (String)iconUrl);
        for (Status status : this.constantsManager.getStatusObjects()) {
            if (!name.trim().equalsIgnoreCase(status.getName())) continue;
            throw new DataAccessException("A status with the name '" + name + "' already exists.");
        }
        try {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("name", name);
            fields.put("description", description);
            fields.put("iconurl", iconUrl);
            fields.put("sequence", new Long(this.getMaxSequenceNo() + 1L));
            String nextStringId = this.getNextStringId();
            Long nextId = Long.valueOf(nextStringId);
            if (nextId < NEW_STATUS_START_ID) {
                fields.put("id", NEW_STATUS_START_ID.toString());
            } else {
                fields.put("id", nextStringId);
            }
            GenericValue statusGv = this.createConstant(fields);
            StatusImpl statusImpl = new StatusImpl(statusGv, this.translationManager, this.jiraAuthenticationContext);
            return statusImpl;
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException("Failed to create new status with name '" + name + "'", (Throwable)ex);
        }
        finally {
            this.clearCaches();
        }
    }

    public void editStatus(Status status, String name, String description, String iconUrl) {
        Assertions.notNull((String)"status", (Object)status);
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notBlank((String)"iconUrl", (String)iconUrl);
        for (Status st : this.getStatuses()) {
            if (!name.equalsIgnoreCase(st.getName()) || status.getId().equals(st.getId())) continue;
            throw new IllegalStateException("Cannot rename status. A status with the name '" + name + "' exists already.");
        }
        try {
            status.setName(name);
            status.setIconUrl(iconUrl);
            status.setDescription(description);
            status.getGenericValue().store();
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Failed to update status '" + status.getName() + "'", (Throwable)e);
        }
    }

    public Collection<Status> getStatuses() {
        return this.constantsManager.getStatusObjects();
    }

    public void removeStatus(String id) {
        Status status = this.getStatus(id);
        if (status == null) {
            throw new IllegalArgumentException("A status with id '" + id + "' does not exist.");
        }
        List existingWorkflows = this.workflowManager.getWorkflowsIncludingDrafts();
        for (JiraWorkflow workflow : existingWorkflows) {
            List linkStatuses = workflow.getLinkedStatuses();
            if (!linkStatuses.contains(status.getGenericValue())) continue;
            throw new IllegalStateException("Cannot delete a status which is associated with a workflow. Status is associated with workflow " + workflow.getName());
        }
        try {
            this.removeConstant(this.getIssueConstantField(), status, null);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Failed to remove status with id '" + id + "'", (Throwable)e);
        }
        catch (IndexException e) {
            throw new DataAccessException("Failed to remove status with id '" + id + "'", (Throwable)e);
        }
    }

    public Status getStatus(String id) {
        Assertions.notBlank((String)"id", (String)id);
        return this.constantsManager.getStatusObject(id);
    }

    @Override
    protected void postProcess(Status constant) {
    }

    @Override
    protected void clearCaches() {
        this.constantsManager.refreshStatuses();
    }

    @Override
    protected String getIssueConstantField() {
        return "Status";
    }

    @Override
    protected List<Status> getAllValues() {
        return Lists.newArrayList(this.getStatuses());
    }
}

