/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bulkedit.operation.AbstractBulkOperation;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.event.issue.IssueEventDispatcher;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ProjectField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionRuntimeException;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanImpl;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class BulkMoveOperationImpl
extends AbstractBulkOperation
implements BulkMoveOperation {
    protected static final Logger log = Logger.getLogger(BulkMoveOperationImpl.class);
    private static final String DESCRIPTION_KEY = "bulk.move.operation.description";
    private static final String CANNOT_PERFORM_MESSAGE_KEY = "bulk.move.cannotperform";
    private final WorkflowManager workflowManager;
    private final ProjectManager projectManager;
    private final FieldManager fieldManager;
    private final IssueFactory issueFactory;
    private final IssueManager issueManager;
    private final AttachmentPathManager attachmentPathManager;

    public BulkMoveOperationImpl(WorkflowManager workflowManager, ProjectManager projectManager, FieldManager fieldManager, IssueFactory issueFactory, IssueManager issueManager, AttachmentPathManager attachmentPathManager) {
        this.workflowManager = workflowManager;
        this.projectManager = projectManager;
        this.fieldManager = fieldManager;
        this.issueFactory = issueFactory;
        this.issueManager = issueManager;
        this.attachmentPathManager = attachmentPathManager;
    }

    public boolean canPerform(BulkEditBean bulkEditBean, User remoteUser) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        PermissionManager permissionManager = ManagerFactory.getPermissionManager();
        for (Issue issueObject : selectedIssues) {
            if (!permissionManager.hasPermission(25, issueObject, remoteUser)) {
                return false;
            }
            Collection subTasks = issueObject.getSubTaskObjects();
            for (Issue subTask : subTasks) {
                if (permissionManager.hasPermission(25, subTask, remoteUser)) continue;
                return false;
            }
        }
        return true;
    }

    public void perform(BulkEditBean bulkEditBean, User remoteUser) throws Exception {
        this.moveIssuesAndIndex(bulkEditBean, remoteUser);
        if (bulkEditBean.getSubTaskBulkEditBean() != null) {
            this.moveIssuesAndIndex(bulkEditBean.getSubTaskBulkEditBean(), remoteUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveIssuesAndIndex(BulkEditBean bulkEditBean, User remoteUser) throws Exception {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        Exception firstException = null;
        for (Object selectedIssue : selectedIssues) {
            MutableIssue issue = (MutableIssue)selectedIssue;
            try {
                Transaction txn = Txn.begin();
                try {
                    this.moveIssueInsideTxn(txn, bulkEditBean, remoteUser, issue);
                }
                catch (Exception e) {
                    log.error((Object)String.format("An exception occured while moving '%s' : %s. Rolling back the operation", issue.getKey(), e.getMessage()));
                    firstException = e;
                }
                finally {
                    txn.finallyRollbackIfNotCommitted();
                }
            }
            catch (TransactionRuntimeException tre) {
                log.error((Object)String.format("Unable to obtain database transaction for '%s' : %s", issue.getKey(), tre.getMessage()));
                firstException = tre;
            }
            if (firstException == null) continue;
            throw firstException;
        }
    }

    private void moveIssueInsideTxn(Transaction txn, BulkEditBean bulkEditBean, User remoteUser, MutableIssue issue) throws Exception {
        MutableIssue newIssue = (MutableIssue)bulkEditBean.getTargetIssueObjects().get(issue);
        boolean issueProjectMoved = !issue.getProjectObject().getId().equals(bulkEditBean.getTargetPid());
        String newKey = issueProjectMoved ? this.getNewKey(bulkEditBean) : null;
        JiraWorkflow originalWorkflow = this.workflowManager.getWorkflow(issue.getGenericValue());
        if (issueProjectMoved) {
            this.moveAttachments((Issue)issue, newKey, bulkEditBean);
        }
        if (!originalWorkflow.equals(bulkEditBean.getTargetWorkflow())) {
            Status newStatus = bulkEditBean.getTargetStatusObject((Issue)issue);
            if (newStatus == null) {
                newStatus = issue.getStatusObject();
            }
            this.workflowManager.migrateIssueToWorkflow(newIssue, bulkEditBean.getTargetWorkflow(), newStatus);
        }
        newIssue.store();
        newIssue.setUpdated(new Timestamp(System.currentTimeMillis()));
        IssueChangeHolder issueChangeHolder = this.moveIssueDetails(issue, newIssue, newKey, bulkEditBean, originalWorkflow);
        GenericValue updateLog = ChangeLogUtils.createChangeGroup(remoteUser, (Issue)issue, (Issue)newIssue, (Collection)issueChangeHolder.getChangeItems(), false);
        txn.commit();
        this.finishUpdate((Issue)newIssue, updateLog, issueChangeHolder, bulkEditBean, remoteUser, issueProjectMoved);
    }

    private void rollback(Transaction txn) {
        txn.rollback();
    }

    public void chooseContextNoValidate(BulkEditBean bulkEditBean, User remoteUser) {
        this.fieldManager.getProjectField().populateFromParams(bulkEditBean.getFieldValuesHolder(), ActionContext.getParameters());
        this.fieldManager.getIssueTypeField().populateFromParams(bulkEditBean.getFieldValuesHolder(), ActionContext.getParameters());
        this.finishChooseContext(bulkEditBean, remoteUser);
    }

    public void chooseContext(BulkEditBean bulkEditBean, User remoteUser, I18nHelper i18nHelper, ErrorCollection errors) {
        Map actionParams = this.extractBulkEditBeanParams(bulkEditBean);
        MutableIssue issueObject = this.getIssueObject(null);
        if (bulkEditBean.isSubTaskCollection()) {
            issueObject.setParentId(new Long(0L));
        }
        SimpleErrorCollection newErrors = new SimpleErrorCollection();
        ProjectField projectField = this.fieldManager.getProjectField();
        projectField.populateFromParams(bulkEditBean.getFieldValuesHolder(), actionParams);
        projectField.validateParams((OperationContext)bulkEditBean, (ErrorCollection)newErrors, i18nHelper, (Issue)issueObject, null);
        GenericValue targetProject = bulkEditBean.getTargetProjectGV();
        issueObject.setProject(targetProject);
        IssueTypeField issueTypeField = this.fieldManager.getIssueTypeField();
        issueTypeField.populateFromParams(bulkEditBean.getFieldValuesHolder(), actionParams);
        issueTypeField.validateParams((OperationContext)bulkEditBean, (ErrorCollection)newErrors, i18nHelper, (Issue)issueObject, null);
        Collection subTaskOptionsForTargetProject = issueTypeField.getOptionsForIssue((Issue)issueObject, true);
        if (subTaskOptionsForTargetProject.isEmpty() && !bulkEditBean.getSubTaskOfSelectedIssues().isEmpty()) {
            newErrors.addError(projectField.getId(), i18nHelper.getText("bulk.move.no.subtask", String.valueOf(bulkEditBean.getSubTaskOfSelectedIssues().size())));
        }
        if (newErrors.hasAnyErrors()) {
            Map errorsForFields = newErrors.getErrors();
            Set entries = errorsForFields.entrySet();
            for (Map.Entry entry : entries) {
                String field = (String)entry.getKey();
                String message = (String)entry.getValue();
                errors.addError(bulkEditBean.getKey() + field, message);
            }
            errors.getErrorMessages().addAll(newErrors.getErrorMessages());
        }
    }

    public void finishChooseContext(MultiBulkMoveBean multiBulkMoveBean, User remoteUser) {
        for (BulkEditBean bulkEditBean : multiBulkMoveBean.getBulkEditBeans().values()) {
            this.finishChooseContext(bulkEditBean, remoteUser);
        }
    }

    public void finishChooseContext(BulkEditBean bulkEditBean, User remoteUser) {
        bulkEditBean.setTargetFieldLayout();
        this.setMoveFieldLayoutItems(bulkEditBean, remoteUser);
        this.setRemovedFields(bulkEditBean, remoteUser);
        GenericValue targetProject = bulkEditBean.getTargetProjectGV();
        ArrayList<Issue> subTasksRequiringMove = new ArrayList<Issue>();
        for (Issue subTask : bulkEditBean.getSubTaskOfSelectedIssues()) {
            if (targetProject.equals((Object)subTask.getProject())) continue;
            subTasksRequiringMove.add(subTask);
        }
        if (!subTasksRequiringMove.isEmpty()) {
            BulkEditBeanImpl subTaskBulkEditBean = new BulkEditBeanImpl(this.issueManager);
            subTaskBulkEditBean.setOperationName(bulkEditBean.getOperationName());
            subTaskBulkEditBean.initSelectedIssues(subTasksRequiringMove);
            subTaskBulkEditBean.setTargetProject(targetProject);
            bulkEditBean.setSubTaskBulkEditBean((BulkEditBean)subTaskBulkEditBean);
        }
    }

    private Map extractBulkEditBeanParams(BulkEditBean bulkEditBean) {
        Object bulkEditIssueTypeId;
        String bulkEditKey = bulkEditBean.getKey();
        Map actionParams = ActionContext.getParameters();
        HashedMap modifiedMap = new HashedMap(actionParams);
        Object bulkeditPid = actionParams.get(bulkEditKey + "pid");
        if (bulkeditPid != null) {
            modifiedMap.put("pid", bulkeditPid);
        }
        if ((bulkEditIssueTypeId = actionParams.get(bulkEditKey + this.fieldManager.getIssueTypeField().getId())) != null) {
            modifiedMap.put(this.fieldManager.getIssueTypeField().getId(), bulkEditIssueTypeId);
        }
        String sameAsBulkEditBean = ParameterUtils.getStringParam((Map)modifiedMap, (String)"sameAsBulkEditBean");
        if (!bulkEditBean.isSubTaskCollection() && StringUtils.isNotBlank((String)sameAsBulkEditBean)) {
            String[] pid = (String[])modifiedMap.get(sameAsBulkEditBean + "pid");
            String[] issueTypeId = (String[])modifiedMap.get(sameAsBulkEditBean + this.fieldManager.getIssueTypeField().getId());
            modifiedMap.put(bulkEditKey + "pid", pid);
            modifiedMap.put(bulkEditKey + this.fieldManager.getIssueTypeField().getId(), issueTypeId);
            modifiedMap.put("pid", pid);
            modifiedMap.put(this.fieldManager.getIssueTypeField().getId(), issueTypeId);
        }
        ActionContext.setParameters((Map)modifiedMap);
        return modifiedMap;
    }

    public boolean isStatusValid(BulkEditBean bulkEditBean) {
        try {
            return bulkEditBean.getInvalidStatuses().isEmpty();
        }
        catch (WorkflowException e) {
            log.warn((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setStatusFields(BulkEditBean bulkEditBean) throws WorkflowException {
        bulkEditBean.populateStatusHolder();
    }

    public void validatePopulateFields(BulkEditBean bulkEditBean, ErrorCollection errors, I18nHelper i18nHelper) {
        Map params = ActionContext.getParameters();
        if (params != null && !params.isEmpty()) {
            Set keys = params.keySet();
            for (String key : keys) {
                if (!key.startsWith("retain")) continue;
                String fieldId = StringUtils.substringAfter((String)key, (String)"retain_");
                bulkEditBean.addRetainValue(fieldId);
            }
        }
        List selectedIssues = bulkEditBean.getSelectedIssues();
        HashSet errorCollection = new HashSet();
        this.calculateFieldSubstitutions(bulkEditBean);
        for (MutableIssue selectedIssue : selectedIssues) {
            this.validateFieldLayoutItems(selectedIssue, (MutableIssue)bulkEditBean.getTargetIssueObjects().get(selectedIssue), bulkEditBean.getMoveFieldLayoutItems(), bulkEditBean, errorCollection, errors, i18nHelper);
        }
    }

    private void calculateFieldSubstitutions(BulkEditBean bulkEditBean) {
        Collection fieldLayoutItems = bulkEditBean.getMoveFieldLayoutItems();
        for (Object o : fieldLayoutItems) {
            FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)o;
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            String fieldId = orderableField.getId();
            if (!orderableField.isShown(bulkEditBean.getFirstTargetIssueObject()) || !this.doesFieldHaveMappings(fieldId, ActionContext.getParameters())) continue;
            Map<Long, Long> substitutions = this.createSubstitutionMap(fieldId, ActionContext.getParameters());
            bulkEditBean.getFieldSubstitutionMap().put(orderableField.getId(), substitutions);
            Map sessionFieldSubstitutionMap = BulkEditBeanSessionHelper.getFromSession().getFieldSubstitutionMap();
            if (sessionFieldSubstitutionMap.containsKey(orderableField.getId())) {
                Map compositeMap = CompositeMap.of(substitutions, (Map)((Map)sessionFieldSubstitutionMap.get(orderableField.getId())));
                sessionFieldSubstitutionMap.put(orderableField.getId(), compositeMap);
                continue;
            }
            sessionFieldSubstitutionMap.put(orderableField.getId(), substitutions);
        }
    }

    private void validateFieldLayoutItems(MutableIssue selectedIssue, MutableIssue targetIssue, Collection fieldLayoutItems, BulkEditBean bulkEditBean, Collection errorCollection, ErrorCollection errors, I18nHelper i18nHelper) {
        FieldLayout targetFieldLayout = bulkEditBean.getTargetFieldLayoutForType(bulkEditBean.getTargetIssueTypeGV().getString("id"));
        for (Object item : fieldLayoutItems) {
            FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)item;
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            String fieldId = orderableField.getId();
            if (orderableField.isShown((Issue)targetIssue)) {
                boolean fieldNeedsMoveForThisIssue = this.fieldNeedsMove(Collections.singletonList(selectedIssue), (Issue)targetIssue, bulkEditBean, targetFieldLayout.getFieldLayoutItem(orderableField)).getResult();
                if (!fieldNeedsMoveForThisIssue && bulkEditBean.isRetainChecked(fieldId)) continue;
                orderableField.populateFromParams(bulkEditBean.getFieldValuesHolder(), ActionContext.getParameters());
                if (this.doesFieldHaveMappings(fieldId, ActionContext.getParameters())) {
                    Map substitutions = (Map)bulkEditBean.getFieldSubstitutionMap().get(fieldId);
                    Object newValue = this.createSubstitutedValues((Issue)selectedIssue, orderableField, substitutions);
                    bulkEditBean.getFieldValuesHolder().put(fieldId, newValue);
                }
                orderableField.validateParams((OperationContext)bulkEditBean, errors, i18nHelper, (Issue)targetIssue, (FieldScreenRenderLayoutItem)new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
                if (errors.hasAnyErrors()) {
                    for (String message : errors.getErrorMessages()) {
                        if (!errorCollection.isEmpty() && errorCollection.contains(message)) continue;
                        errorCollection.add(message);
                    }
                    errors.setErrorMessages(new ArrayList());
                    continue;
                }
                orderableField.updateIssue(fieldLayoutItem, targetIssue, bulkEditBean.getFieldValuesHolder());
                continue;
            }
            orderableField.populateDefaults(bulkEditBean.getFieldValuesHolder(), (Issue)targetIssue);
            SimpleErrorCollection errorCollection2 = new SimpleErrorCollection();
            orderableField.validateParams((OperationContext)bulkEditBean, (ErrorCollection)errorCollection2, i18nHelper, (Issue)targetIssue, (FieldScreenRenderLayoutItem)new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
            if (errorCollection2.getErrors() != null && !errorCollection2.getErrors().isEmpty()) {
                Iterator<Object> iterator2 = errorCollection2.getErrors().values().iterator();
                while (iterator2.hasNext()) {
                    errors.addErrorMessage(this.getFieldName((Field)orderableField, i18nHelper) + ": " + iterator2.next());
                }
                continue;
            }
            orderableField.updateIssue(fieldLayoutItem, targetIssue, bulkEditBean.getFieldValuesHolder());
        }
        errors.addErrorMessages(errorCollection);
    }

    private Object createSubstitutedValues(Issue selectedIssue, OrderableField orderableField, Map<Long, Long> substitutions) {
        if (orderableField instanceof CustomField) {
            return this.createSubstitutedValuesForCustomFields(selectedIssue, (CustomField)orderableField, substitutions);
        }
        return this.createSubstitutedValuesForSystemFields(selectedIssue, orderableField, substitutions);
    }

    private Collection<Long> createSubstitutedValuesForSystemFields(Issue selectedIssue, OrderableField orderableField, Map<Long, Long> substitutions) {
        String fieldId = orderableField.getId();
        LinkedHashMap workingMap = new LinkedHashMap();
        orderableField.populateFromIssue(workingMap, selectedIssue);
        Collection existingIds = (Collection)workingMap.get(fieldId);
        ArrayList<Long> newValues = new ArrayList<Long>();
        if (existingIds != null) {
            if (existingIds.isEmpty() && substitutions.containsKey(-1L)) {
                newValues.add(substitutions.get(-1L));
            } else {
                for (Long existingId : existingIds) {
                    Long newValue;
                    if (existingId == null || (newValue = substitutions.get(existingId)) == null) continue;
                    newValues.add(newValue);
                }
            }
        }
        return newValues;
    }

    private CustomFieldParams createSubstitutedValuesForCustomFields(Issue selectedIssue, CustomField customField, Map<Long, Long> substitutions) {
        String fieldId = customField.getId();
        LinkedHashMap workingMap = new LinkedHashMap();
        customField.populateFromIssue(workingMap, selectedIssue);
        CustomFieldParams existingValues = (CustomFieldParams)workingMap.get(fieldId);
        ArrayList<String> newValues = new ArrayList<String>();
        if (existingValues != null) {
            Collection existingIdsAsStrings = existingValues.getAllValues();
            if (existingIdsAsStrings.isEmpty() && substitutions.containsKey(-1L)) {
                newValues.add(substitutions.get(-1L).toString());
            } else {
                for (String existingId : existingIdsAsStrings) {
                    Long key;
                    Long newValue;
                    if (existingId == null || (newValue = substitutions.get(key = this.parseLong(existingId))) == null) continue;
                    newValues.add(newValue.toString());
                }
            }
        }
        return new CustomFieldParamsImpl(customField, newValues);
    }

    private Map<Long, Long> createSubstitutionMap(String fieldId, Map<String, Object> actionParameters) {
        Pattern pattern = Pattern.compile(fieldId + "_(.+)");
        TreeMap<Long, Long> result = new TreeMap<Long, Long>();
        for (String paramName : actionParameters.keySet()) {
            Long newId;
            String value;
            Long oldId;
            Matcher matcher = pattern.matcher(paramName);
            if (!matcher.matches() || (oldId = this.parseLong(matcher.group(1))) == null || (value = ParameterUtils.getStringParam(actionParameters, (String)paramName)) == null || (newId = this.parseLong(value)) == null) continue;
            if (newId.equals(-1L)) {
                newId = null;
            }
            result.put(oldId, newId);
        }
        return result;
    }

    private Long parseLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private boolean doesFieldHaveMappings(String fieldId, Map parameters) {
        String prefix = fieldId + "_";
        for (Object o : parameters.keySet()) {
            String key = (String)o;
            if (!key.startsWith(prefix)) continue;
            String suffix = key.substring(prefix.length());
            try {
                Long.parseLong(suffix);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getFieldName(Field field, I18nHelper i18nHelper) {
        if (field instanceof CustomField) {
            return field.getName();
        }
        return i18nHelper.getText(field.getNameKey());
    }

    private void setMoveFieldLayoutItems(BulkEditBean bulkEditBean, User remoteUser) {
        HashSet<FieldLayoutItem> moveFieldLayoutItems = new HashSet<FieldLayoutItem>();
        HashMap<String, MessagedResult> messagedFieldLayoutItems = new HashMap<String, MessagedResult>();
        FieldLayout targetFieldLayout = bulkEditBean.getTargetFieldLayout();
        for (FieldLayoutItem fieldLayoutItem : targetFieldLayout.getVisibleLayoutItems(remoteUser, bulkEditBean.getTargetProject(), EasyList.build((Object)bulkEditBean.getTargetIssueTypeId()))) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            if ("issuetype".equals(orderableField.getId())) continue;
            MessagedResult messagedResult = this.fieldNeedsMove(fieldLayoutItem, bulkEditBean);
            if (messagedResult.getResult()) {
                moveFieldLayoutItems.add(fieldLayoutItem);
                continue;
            }
            if (messagedResult.getMessage() == null) continue;
            messagedFieldLayoutItems.put(fieldLayoutItem.getOrderableField().getName(), messagedResult);
        }
        bulkEditBean.setMessagedFieldLayoutItems(messagedFieldLayoutItems);
        bulkEditBean.setMoveFieldLayoutItems(moveFieldLayoutItems);
    }

    private MessagedResult fieldNeedsMove(FieldLayoutItem fieldLayoutItem, BulkEditBean bulkEditBean) {
        return this.fieldNeedsMove(bulkEditBean.getSelectedIssues(), bulkEditBean.getFirstTargetIssueObject(), bulkEditBean, fieldLayoutItem);
    }

    private MessagedResult fieldNeedsMove(Collection originalIssues, Issue firstTargetIssueObject, BulkEditBean bulkEditBean, FieldLayoutItem fieldLayoutItem) {
        OrderableField orderableField = fieldLayoutItem.getOrderableField();
        if (bulkEditBean.getParentBulkEditBean() != null && orderableField.getId().equals("security") && this.bulkEditBeanIsChangingField(bulkEditBean.getParentBulkEditBean(), "security")) {
            return new MessagedResult(true);
        }
        return orderableField.needsMove(originalIssues, firstTargetIssueObject, fieldLayoutItem);
    }

    private boolean bulkEditBeanIsChangingField(BulkEditBean bulkEditBean, String fieldID) {
        for (FieldLayoutItem fieldLayoutItem : bulkEditBean.getMoveFieldLayoutItems()) {
            if (fieldLayoutItem.getOrderableField() == null || !fieldID.equals(fieldLayoutItem.getOrderableField().getId())) continue;
            return true;
        }
        return false;
    }

    private void setRemovedFields(BulkEditBean bulkEditBean, User remoteUser) {
        HashSet<OrderableField> removedFields = new HashSet<OrderableField>();
        List selectedIssues = bulkEditBean.getSelectedIssues();
        Collection targetHiddenFields = this.getTargetHiddenFields(bulkEditBean, remoteUser);
        for (MutableIssue issue : selectedIssues) {
            for (Field field : targetHiddenFields) {
                OrderableField orderableField;
                if (!this.fieldManager.isOrderableField(field) || !(orderableField = (OrderableField)field).hasValue((Issue)issue)) continue;
                MutableIssue targetIssue = (MutableIssue)bulkEditBean.getTargetIssueObjects().get(issue);
                if (targetIssue == null) {
                    throw new IllegalStateException("Could not find target issue for issue " + issue.getKey() + " in BulkMoveOperation.");
                }
                if (!orderableField.canRemoveValueFromIssueObject((Issue)targetIssue)) continue;
                orderableField.removeValueFromIssueObject(targetIssue);
                removedFields.add(orderableField);
            }
        }
        bulkEditBean.setRemovedFields(removedFields);
    }

    protected Collection getTargetHiddenFields(BulkEditBean bulkEditBean, User remoteUser) {
        return bulkEditBean.getTargetFieldLayout().getHiddenFields(remoteUser, bulkEditBean.getTargetProjectGV(), EasyList.build((Object)bulkEditBean.getTargetIssueTypeId()));
    }

    public String getNameKey() {
        return "bulk.move.operation.name";
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public String getOperationName() {
        return "BulkMove";
    }

    public String getCannotPerformMessageKey() {
        return CANNOT_PERFORM_MESSAGE_KEY;
    }

    public JiraWorkflow getWorkflowForType(Long projectId, String issueTypeId) throws WorkflowException {
        return this.workflowManager.getWorkflow(projectId, issueTypeId);
    }

    private void moveAttachments(Issue issue, String newIssueKey, BulkEditBean bulkEditBean) throws Exception {
        Collection attachments = issue.getAttachments();
        for (Attachment attachment : attachments) {
            File originalAttachmentFile = AttachmentUtils.getAttachmentFile((Issue)issue, (Attachment)attachment);
            String fileName = originalAttachmentFile.getName();
            String originalFilePath = this.getAttachmentPath(issue.getProjectObject().getKey(), issue.getKey()) + "/" + fileName;
            log.debug((Object)("Attachment: " + originalFilePath));
            String targetDirectoryPath = this.getAttachmentPath(bulkEditBean.getTargetProjectGV().getString("key"), newIssueKey);
            log.debug((Object)("Attachment: " + targetDirectoryPath + "/" + fileName));
            File attachmentFile = new File(originalFilePath);
            if (!attachmentFile.exists()) {
                MutableIssue latestIssue = this.issueManager.getIssueObject(issue.getId());
                if (latestIssue.getKey().equals(issue.getKey())) {
                    log.warn((Object)("The attachment '" + attachment.getFilename() + "' for issue '" + issue.getKey() + "' was not found in expected path '" + originalFilePath + "'. Attachment cannot be moved."));
                    attachmentFile = null;
                } else {
                    originalFilePath = this.getAttachmentPath(latestIssue.getProjectObject().getKey(), latestIssue.getKey()) + "/" + fileName;
                    attachmentFile = new File(originalFilePath);
                    if (attachmentFile.exists()) {
                        log.warn((Object)("The attachment '" + attachment.getFilename() + "' for issue '" + issue.getKey() + "' was not found in expected path '" + originalFilePath + "'. This issue has been moved to '" + latestIssue.getKey() + "', we will move the attachment from '" + originalFilePath + "'."));
                    } else {
                        log.warn((Object)("The attachment '" + attachment.getFilename() + "' for issue '" + issue.getKey() + "' was not found in expected path '" + originalFilePath + "'. This issue has been moved to '" + latestIssue.getKey() + "', but the attachment is not in the new path '" + originalFilePath + "' either."));
                        attachmentFile = null;
                    }
                }
            }
            if (attachmentFile == null) continue;
            File destDirectory = new File(targetDirectoryPath);
            destDirectory.mkdirs();
            attachmentFile.renameTo(new File(destDirectory, fileName));
        }
    }

    private String getAttachmentPath(String projectKey, String issueKey) {
        return this.attachmentPathManager.getAttachmentPath() + "/" + projectKey + "/" + issueKey;
    }

    private String getNewKey(BulkEditBean bulkEditBean) {
        Project targetProject = bulkEditBean.getTargetProject();
        if (targetProject != null) {
            long incCount = this.projectManager.getNextId(targetProject);
            return targetProject.getKey() + "-" + incCount;
        }
        log.error((Object)"Unable to determine new key for issue.");
        return null;
    }

    private IssueChangeHolder moveIssueDetails(MutableIssue oldIssue, MutableIssue newIssue, String newKey, BulkEditBean bulkEditBean, JiraWorkflow originalWorkflow) throws WorkflowException {
        DefaultIssueChangeHolder issueChangeHolder = new DefaultIssueChangeHolder();
        GenericValue currentProjectGV = oldIssue.getProject();
        GenericValue targetProjectGV = bulkEditBean.getTargetProjectGV();
        String oldKey = oldIssue.getString("key");
        String newWorkflowId = newIssue.getGenericValue().getLong("workflowId").toString();
        if (!currentProjectGV.equals((Object)targetProjectGV)) {
            issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "Project", currentProjectGV.getLong("id").toString(), currentProjectGV.getString("name"), targetProjectGV.getLong("id").toString(), targetProjectGV.getString("name")));
            if (newKey != null) {
                issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "Key", null, oldKey, null, newKey));
                newIssue.setKey(newKey);
            }
        }
        if (!originalWorkflow.equals(bulkEditBean.getTargetWorkflow())) {
            issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "Workflow", oldIssue.getWorkflowId().toString(), originalWorkflow.getName(), newWorkflowId, bulkEditBean.getTargetWorkflow().getName()));
            Status originalStatus = oldIssue.getStatusObject();
            Status newStatus = newIssue.getStatusObject();
            if (originalStatus != null && !originalStatus.equals(newStatus)) {
                issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "status", originalStatus.getId(), originalStatus.getName(), newStatus.getId(), newStatus.getName()));
            }
        }
        Map modifiedFields = newIssue.getModifiedFields();
        for (String fieldId : modifiedFields.keySet()) {
            if (!this.fieldManager.isOrderableField(fieldId)) continue;
            OrderableField field = this.fieldManager.getOrderableField(fieldId);
            if (bulkEditBean.getRetainValues() != null && bulkEditBean.getRetainValues().contains(fieldId)) {
                FieldLayout targetFieldLayout = bulkEditBean.getTargetFieldLayoutForType(bulkEditBean.getTargetIssueTypeGV().getString("id"));
                if (!field.needsMove((Collection)EasyList.build((Object)oldIssue), (Issue)newIssue, targetFieldLayout.getFieldLayoutItem(field)).getResult()) continue;
                field.updateValue(targetFieldLayout.getFieldLayoutItem(field), (Issue)newIssue, (ModifiedValue)modifiedFields.get(fieldId), (IssueChangeHolder)issueChangeHolder);
                continue;
            }
            FieldLayoutItem fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(newIssue.getProjectObject(), newIssue.getIssueTypeObject().getId()).getFieldLayoutItem(field);
            field.updateValue(fieldLayoutItem, (Issue)newIssue, (ModifiedValue)modifiedFields.get(fieldId), (IssueChangeHolder)issueChangeHolder);
        }
        newIssue.store();
        newIssue.resetModifiedFields();
        return issueChangeHolder;
    }

    private void finishUpdate(Issue newIssue, GenericValue updateLog, IssueChangeHolder issueChangeHolder, BulkEditBean bulkEditBean, User remoteUser, boolean issueProjectMoved) {
        if (updateLog != null && !issueChangeHolder.getChangeItems().isEmpty()) {
            boolean sendMail = bulkEditBean.isSendBulkNotification();
            Long eventTypeId = issueProjectMoved ? EventType.ISSUE_MOVED_ID : EventType.ISSUE_UPDATED_ID;
            IssueEventDispatcher.dispatchEvent(eventTypeId, newIssue, remoteUser, updateLog, sendMail, issueChangeHolder.isSubtasksUpdated());
        }
    }

    private MutableIssue getIssueObject(GenericValue issue) {
        return this.issueFactory.getIssue(issue);
    }
}

