/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit;

import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.BulkDeleteOperation;
import com.atlassian.jira.bulkedit.operation.BulkEditOperation;
import com.atlassian.jira.bulkedit.operation.BulkMigrateOperation;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.bulkedit.operation.BulkWorkflowTransitionOperation;
import com.atlassian.jira.util.JiraUtils;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.log4j.Logger;

public class DefaultBulkOperationManager
implements BulkOperationManager {
    private static final Logger log = Logger.getLogger(DefaultBulkOperationManager.class);
    private Map<String, BulkOperation> bulkOperations = new ListOrderedMap();

    public DefaultBulkOperationManager() {
        this.bulkOperations.put("bulk.edit.operation.name", JiraUtils.loadComponent(BulkEditOperation.class));
        BulkMigrateOperation bulkMigrateOperation = JiraUtils.loadComponent(BulkMigrateOperation.class);
        this.bulkOperations.put(bulkMigrateOperation.getNameKey(), bulkMigrateOperation);
        this.bulkOperations.put("bulk.workflowtransition.operation.name", JiraUtils.loadComponent(BulkWorkflowTransitionOperation.class));
        this.bulkOperations.put("bulk.delete.operation.name", new BulkDeleteOperation());
    }

    public Collection<BulkOperation> getBulkOperations() {
        return this.bulkOperations.values();
    }

    public BulkOperation getOperation(String operationName) {
        return this.getBulkOperationsMap().get(operationName);
    }

    public boolean isValidOperation(String operationName) {
        return this.getBulkOperationsMap().containsKey(operationName);
    }

    public void addBulkOperation(String operationName, Class<BulkOperation> componentClass) {
        log.info((Object)("Adding Bulk Operation " + operationName + " with class " + componentClass));
        this.bulkOperations.put(operationName, JiraUtils.loadComponent(componentClass));
    }

    protected Map<String, BulkOperation> getBulkOperationsMap() {
        return this.bulkOperations;
    }
}

