/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.search;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.issue.search.IssuePickerResults;
import com.atlassian.jira.bc.issue.search.IssuePickerSearchProvider;
import com.atlassian.jira.bc.issue.search.IssuePickerSearchService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.util.LuceneQueryModifier;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lucene.ConstantScorePrefixQuery;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.QueryImpl;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public abstract class AbstractIssuePickerSearchProvider
implements IssuePickerSearchProvider {
    private static final Logger log = Logger.getLogger(AbstractIssuePickerSearchProvider.class);
    private final SearchProvider searchProvider;
    private final ConstantsManager constantsManager;
    private final LuceneQueryModifier modifier;
    final Analyzer keyAnalyzer = new WhitespaceAnalyzer();
    Analyzer summaryAnalyzer = DefaultIndexManager.ANALYZER_FOR_SEARCHING;

    protected AbstractIssuePickerSearchProvider(SearchProvider searchProvider, ConstantsManager constantsManager, LuceneQueryModifier modifier) {
        this.searchProvider = searchProvider;
        this.constantsManager = constantsManager;
        this.modifier = modifier;
    }

    @Override
    public IssuePickerResults getResults(JiraServiceContext context, IssuePickerSearchService.IssuePickerParameters issuePickerParams, int maxIssueCount) {
        List results = Collections.emptyList();
        List<String> keyTerms = Collections.emptyList();
        List<String> summaryTerms = Collections.emptyList();
        SearchRequest currentSearch = this.getRequest(issuePickerParams);
        int total = -1;
        if (currentSearch == null) {
            return new IssuePickerResults(results, 0, keyTerms, summaryTerms, this.getLabelKey(), this.getId());
        }
        try {
            SearchRequest sr = AbstractIssuePickerSearchProvider.getNoSortRequest(currentSearch);
            String query = StringUtils.trimToNull((String)issuePickerParams.getQuery());
            keyTerms = new LinkedHashSet();
            summaryTerms = new LinkedHashSet();
            Query filterQuery = this.createQuery(query, keyTerms, summaryTerms);
            filterQuery = this.addFilterToQuery(issuePickerParams, filterQuery);
            filterQuery = this.modifier.getModifiedQuery(filterQuery);
            PagerFilter pagerFilter = new PagerFilter(maxIssueCount);
            SearchResults searchResults = this.searchProvider.search(sr.getQuery(), context.getLoggedInUser(), pagerFilter, filterQuery);
            results = searchResults.getIssues();
            total = searchResults.getTotal();
        }
        catch (Exception e) {
            log.error((Object)"Error while executing search request", (Throwable)e);
        }
        return new IssuePickerResults(results, total, Collections.unmodifiableCollection(keyTerms), Collections.unmodifiableCollection(summaryTerms), this.getLabelKey(), this.getId());
    }

    Query addFilterToQuery(IssuePickerSearchService.IssuePickerParameters issuePickerParams, Query filterQuery) {
        Issue currentIssue = issuePickerParams.getCurrentIssue();
        Project project = issuePickerParams.getCurrentProject();
        BooleanQuery newFilterQuery = new BooleanQuery();
        if (filterQuery != null) {
            newFilterQuery.add(filterQuery, BooleanClause.Occur.MUST);
        }
        if (currentIssue != null) {
            newFilterQuery.add((Query)new TermQuery(new Term("key", currentIssue.getKey())), BooleanClause.Occur.MUST_NOT);
        }
        if (project != null) {
            newFilterQuery.add((Query)new TermQuery(new Term("projid", project.getId().toString())), BooleanClause.Occur.MUST);
        }
        if (!issuePickerParams.showSubTasks()) {
            BooleanQuery issueTypeQuery = new BooleanQuery();
            for (IssueType issueType : this.constantsManager.getRegularIssueTypeObjects()) {
                issueTypeQuery.add((Query)new TermQuery(new Term("type", issueType.getId())), BooleanClause.Occur.SHOULD);
            }
            newFilterQuery.add((Query)issueTypeQuery, BooleanClause.Occur.MUST);
        }
        if (currentIssue != null && currentIssue.getParentObject() != null && !issuePickerParams.showSubTaskParent()) {
            newFilterQuery.add((Query)new TermQuery(new Term("key", currentIssue.getParentObject().getKey())), BooleanClause.Occur.MUST_NOT);
        }
        if (!newFilterQuery.clauses().isEmpty()) {
            return newFilterQuery;
        }
        return null;
    }

    Query createQuery(String query, Collection<String> keyTerms, Collection<String> summaryTerms) {
        if (query == null) {
            return null;
        }
        BooleanQuery combinedQuery = new BooleanQuery();
        TermQuery exactKeyQuery = new TermQuery(new Term("key", query.toUpperCase()));
        exactKeyQuery.setBoost(2.0f);
        TermQuery exactKeyNumQuery = new TermQuery(new Term("keynumpart", query.toUpperCase()));
        exactKeyNumQuery.setBoost(1.8f);
        QueryCreator keyQueryCreator = new QueryCreator(query.toUpperCase(), "key", this.keyAnalyzer, new ConstantScorePrefixSubQuery());
        Query keyQueryOR = keyQueryCreator.getQuery();
        keyTerms.clear();
        keyTerms.addAll(keyQueryCreator.getTokens());
        QueryCreator keyNumQueryCreator = new QueryCreator(query.toUpperCase(), "keynumpart", this.keyAnalyzer, new ConstantScorePrefixSubQuery());
        Query keyNumQueryOR = keyNumQueryCreator.getQuery();
        keyNumQueryOR.setBoost(1.5f);
        QueryCreator summaryQueryCreator = new QueryCreator(query.toLowerCase(), "summary", (Analyzer)new WhitespaceAnalyzer(), new PrefixSubQuery());
        Query summaryQueryOR = summaryQueryCreator.getQuery();
        summaryTerms.clear();
        summaryTerms.addAll(summaryQueryCreator.getTokens());
        QueryCreator summaryTermQueryCreator = new QueryCreator(query, "summary", this.summaryAnalyzer, new TermSubQuery());
        Query summaryTermQueryOR = summaryTermQueryCreator.getQuery();
        summaryTerms.addAll(summaryTermQueryCreator.getTokens());
        combinedQuery.add(keyQueryOR, BooleanClause.Occur.SHOULD);
        combinedQuery.add(keyNumQueryOR, BooleanClause.Occur.SHOULD);
        combinedQuery.add(summaryQueryOR, BooleanClause.Occur.SHOULD);
        combinedQuery.add(summaryTermQueryOR, BooleanClause.Occur.SHOULD);
        combinedQuery.add((Query)exactKeyQuery, BooleanClause.Occur.SHOULD);
        combinedQuery.add((Query)exactKeyNumQuery, BooleanClause.Occur.SHOULD);
        return combinedQuery;
    }

    protected abstract String getLabelKey();

    protected abstract String getId();

    protected abstract SearchRequest getRequest(IssuePickerSearchService.IssuePickerParameters var1);

    static SearchRequest getNoSortRequest(SearchRequest searchRequest) {
        if (searchRequest == null) {
            return null;
        }
        com.atlassian.query.Query query = searchRequest.getQuery();
        return new SearchRequest((com.atlassian.query.Query)new QueryImpl(query.getWhereClause(), null, null));
    }

    static class TermSubQuery
    implements SubQuery {
        TermSubQuery() {
        }

        @Override
        public Query getSubQuery(String fieldName, String term) {
            return new TermQuery(new Term(fieldName, term));
        }
    }

    static class ConstantScorePrefixSubQuery
    implements SubQuery {
        ConstantScorePrefixSubQuery() {
        }

        @Override
        public Query getSubQuery(String fieldName, String term) {
            return new ConstantScorePrefixQuery(new Term(fieldName, term));
        }
    }

    static class PrefixSubQuery
    implements SubQuery {
        PrefixSubQuery() {
        }

        @Override
        public Query getSubQuery(String fieldName, String term) {
            return new PrefixQuery(new Term(fieldName, term));
        }
    }

    static class WildCardSubQuery
    implements SubQuery {
        WildCardSubQuery() {
        }

        @Override
        public Query getSubQuery(String fieldName, String termText) {
            StringBuilder sb = new StringBuilder();
            boolean anyInt = false;
            try {
                new Integer(termText);
                sb.append("*-");
                anyInt = true;
            }
            catch (NumberFormatException e) {
                sb.append("*");
            }
            sb.append(termText);
            if (!anyInt) {
                sb.append("*");
            }
            WildcardQuery subQuery = new WildcardQuery(new Term(fieldName, sb.toString()));
            if (anyInt) {
                subQuery.setBoost(1.5f);
            }
            return subQuery;
        }
    }

    static interface SubQuery {
        public Query getSubQuery(String var1, String var2);
    }

    static final class QueryCreator {
        final String fieldName;
        private final BooleanClause.Occur occurence = BooleanClause.Occur.SHOULD;
        private final Collection<String> tokens = new ArrayList<String>();
        private final SubQuery subQueryCreator;

        QueryCreator(String queryString, String fieldName, Analyzer analyzer, SubQuery subQueryCreator) {
            this.fieldName = (String)Assertions.notNull((String)"You must provide a field name", (Object)fieldName);
            Assertions.notNull((String)"You must provide a Analyzer", (Object)analyzer);
            this.subQueryCreator = (SubQuery)Assertions.notNull((String)"subQueryCreator", (Object)subQueryCreator);
            queryString = queryString == null ? "" : queryString;
            try {
                TokenStream tokenStream = analyzer.tokenStream(null, (Reader)new StringReader(queryString));
                CharTermAttribute termAttribute = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
                while (tokenStream.incrementToken()) {
                    int termLength = termAttribute.length();
                    this.tokens.add(((Object)termAttribute.subSequence(0, termLength)).toString());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }

        public Collection<String> getTokens() {
            return this.tokens;
        }

        public final Query getQuery() {
            BooleanQuery query = new BooleanQuery();
            for (String term : this.getTokens()) {
                query.add(this.subQueryCreator.getSubQuery(this.fieldName, term), this.occurence);
            }
            return query;
        }
    }
}

