/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import org.apache.commons.lang.StringUtils;

public final class DataImportParams {
    private final String filename;
    private final String licenseString;
    private final boolean quickImport;
    private final boolean useDefaultPaths;
    private final boolean isSetup;

    private DataImportParams(String filename, String licenseString, boolean quickImport, boolean useDefaultPaths, boolean isSetup) {
        this.filename = filename;
        this.licenseString = licenseString;
        this.quickImport = quickImport;
        this.useDefaultPaths = useDefaultPaths;
        this.isSetup = isSetup;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public boolean isQuickImport() {
        return this.quickImport;
    }

    public boolean isUseDefaultPaths() {
        return this.useDefaultPaths;
    }

    public boolean isSetup() {
        return this.isSetup;
    }

    public static class Builder {
        private final String filename;
        private String licenseString;
        private boolean quickImport = false;
        private boolean useDefaultPaths = true;
        private boolean isSetup = false;

        public Builder(String filename) {
            this.filename = StringUtils.stripToEmpty((String)filename);
        }

        public Builder setupImport() {
            this.isSetup = true;
            return this;
        }

        public Builder setLicenseString(String licenseString) {
            this.licenseString = StringUtils.stripToNull((String)licenseString);
            return this;
        }

        public Builder setQuickImport(boolean quickImport) {
            this.quickImport = quickImport;
            return this;
        }

        public Builder setUseDefaultPaths(boolean useDefaultPaths) {
            this.useDefaultPaths = useDefaultPaths;
            return this;
        }

        public DataImportParams build() {
            return new DataImportParams(this.filename, this.licenseString, this.quickImport, this.useDefaultPaths, this.isSetup);
        }
    }
}

