/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarsDisabledException;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.opensymphony.module.propertyset.PropertySet;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarServiceImpl
implements AvatarService {
    private final Logger log = LoggerFactory.getLogger(AvatarServiceImpl.class);
    private final UserManager userManager;
    private final AvatarManager avatarManager;
    private final UserPropertyManager userPropertyManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;

    public AvatarServiceImpl(UserManager userManager, AvatarManager avatarManager, UserPropertyManager userPropertyManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties) {
        this.userManager = userManager;
        this.avatarManager = avatarManager;
        this.userPropertyManager = userPropertyManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
    }

    public Avatar getAvatar(User remoteUser, String avatarUserId) throws AvatarsDisabledException {
        return this.getAvatarImpl(remoteUser, false, avatarUserId);
    }

    private Avatar getAvatarImpl(User remoteUser, boolean skipPermissionCheck, String avatarUserId) {
        User user = this.userManager.getUserObject(avatarUserId);
        if (user != null) {
            Avatar avatar;
            Long customAvatarId = this.configuredAvatarIdFor(user);
            if (customAvatarId != null && (avatar = this.avatarManager.getById(customAvatarId)) != null && (skipPermissionCheck || this.canViewAvatar(remoteUser, avatar))) {
                return avatar;
            }
            Long defaultAvatarId = this.avatarManager.getDefaultAvatarId(Avatar.Type.USER);
            this.log.debug("Avatar not configured for user '{}', using default id {}", (Object)avatarUserId, (Object)defaultAvatarId);
            return defaultAvatarId != null ? this.avatarManager.getById(defaultAvatarId) : null;
        }
        Long anonAvatarId = this.avatarManager.getAnonymousAvatarId();
        this.log.debug("User '{}' does not exist, using anonymous avatar id {}", (Object)avatarUserId, (Object)anonAvatarId);
        return anonAvatarId != null ? this.avatarManager.getById(anonAvatarId) : null;
    }

    public URI getAvatarURL(User remoteUser, String avatarUserId, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUserId, size, this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl());
    }

    public URI getAvatarUrlNoPermCheck(String avatarUserId, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(null, true, avatarUserId, size, this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl());
    }

    public URI getAvatarAbsoluteURL(User remoteUser, String avatarUserId, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUserId, size, this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl());
    }

    private URI getAvatarURLImpl(User remoteUser, boolean skipPermissionCheck, String avatarUserId, Avatar.Size size, String baseUrl) {
        Long avatarId;
        String ownerId;
        Avatar avatar = this.getAvatarImpl(remoteUser, skipPermissionCheck, avatarUserId);
        UrlBuilder urlBuilder = new UrlBuilder(baseUrl + "/secure/useravatar", this.applicationProperties.getEncoding(), false);
        if (size != null && !size.isDefault) {
            urlBuilder.addParameter("size", size.param);
        }
        String string = ownerId = avatar != null ? avatar.getOwner() : null;
        if (ownerId != null) {
            urlBuilder.addParameter("ownerId", ownerId);
        }
        Long l = avatarId = avatar != null ? avatar.getId() : null;
        if (avatarId != null) {
            urlBuilder.addParameter("avatarId", avatarId.toString());
        }
        return urlBuilder.asURI();
    }

    public URI getProjectAvatarURL(Project project, Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        return this.getProjectAvatarURLImpl(project, size, baseUrl);
    }

    public URI getProjectAvatarAbsoluteURL(Project project, Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        return this.getProjectAvatarURLImpl(project, size, baseUrl);
    }

    private URI getProjectAvatarURLImpl(Project project, Avatar.Size size, String baseUrl) {
        Long avatarId;
        UrlBuilder urlBuilder = new UrlBuilder(baseUrl + "/secure/projectavatar", this.applicationProperties.getEncoding(), false);
        if (size != null && !size.isDefault) {
            urlBuilder.addParameter("size", size.param);
        }
        urlBuilder.addParameter("pid", (Object)project.getId());
        Avatar avatar = project.getAvatar();
        Long l = avatarId = avatar != null ? avatar.getId() : null;
        if (avatarId != null) {
            urlBuilder.addParameter("avatarId", avatarId.toString());
        }
        return urlBuilder.asURI();
    }

    protected Long configuredAvatarIdFor(User user) {
        PropertySet userProperties = this.userPropertyManager.getPropertySet(user);
        if (userProperties.exists("user.avatar.id")) {
            long avatarId = userProperties.getLong("user.avatar.id");
            this.log.debug("Avatar configured for user '{}' is {}", (Object)user.getName(), (Object)avatarId);
            return avatarId;
        }
        return null;
    }

    protected boolean canViewAvatar(User user, Avatar avatar) {
        boolean hasPermission = this.avatarManager.hasPermissionToView(user, avatar.getAvatarType(), avatar.getOwner());
        if (!hasPermission) {
            this.log.debug("User '{}' is not allowed to view avatar {}", (Object)user, (Object)avatar.getId());
        }
        return hasPermission;
    }
}

