/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.check.EntityCheck;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.appconsistency.integrity.integritycheck.EntityIntegrityCheck;
import com.atlassian.jira.appconsistency.integrity.integritycheck.IntegrityCheck;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;

public abstract class EntityCheckImpl
extends CheckImpl
implements EntityCheck {
    private EntityIntegrityCheck entityIntegrityCheck;

    protected EntityCheckImpl(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public EntityIntegrityCheck getEntityIntegrityCheck() {
        return this.entityIntegrityCheck;
    }

    @Override
    public void setEntityIntegrityCheck(EntityIntegrityCheck entityIntegrityCheck) {
        this.entityIntegrityCheck = entityIntegrityCheck;
    }

    @Override
    public IntegrityCheck getIntegrityCheck() {
        return this.entityIntegrityCheck;
    }

    @Override
    public void setIntegrityCheck(IntegrityCheck integrityCheck) {
        if (!(integrityCheck instanceof EntityIntegrityCheck)) {
            throw new IllegalArgumentException("Entity Check must have an Entity Integrity Check");
        }
        this.setEntityIntegrityCheck((EntityIntegrityCheck)integrityCheck);
    }

    protected String getEntityName() {
        return this.getEntityIntegrityCheck().getEntityName();
    }

    protected OfBizListIterator getEntities(String entityName) throws IntegrityException {
        return this.ofBizDelegator.findListIteratorByCondition(entityName, null);
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }
}

