/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.admin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.webfragment.DefaultSimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.user.DefaultUserIssueHistoryManager;
import com.atlassian.jira.user.UserAdminHistoryManager;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import webwork.action.ServletActionContext;

public class AdminHistoryLinkFactory
implements SimpleLinkFactory {
    private static final Logger log = Logger.getLogger(DefaultUserIssueHistoryManager.class);
    private final UserAdminHistoryManager userAdminHistoryManager;
    private final DefaultSimpleLinkManager defaultSimpleLinkManager;
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private static final String SYSTEM_ADMIN_LOCATION = "system.admin";

    public AdminHistoryLinkFactory(UserAdminHistoryManager userAdminHistoryManager, DefaultSimpleLinkManager defaultSimpleLinkManager, PluginAccessor pluginAccessor, ApplicationProperties applicationProperties) {
        this.userAdminHistoryManager = userAdminHistoryManager;
        this.defaultSimpleLinkManager = defaultSimpleLinkManager;
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = applicationProperties;
    }

    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
    }

    public List<SimpleLink> getLinks(User user, Map<String, Object> params) {
        List history = this.userAdminHistoryManager.getAdminPageHistoryWithoutPermissionChecks(user);
        LinkedHashMap<String, SimpleLink> linkIdMap = new LinkedHashMap<String, SimpleLink>();
        if (history != null && !history.isEmpty()) {
            JiraHelper helper = new JiraHelper(ServletActionContext.getRequest());
            List<SimpleLinkSection> section = this.defaultSimpleLinkManager.getSectionsForLocation(SYSTEM_ADMIN_LOCATION, user, helper);
            ArrayList<String> moduleIdList = new ArrayList<String>();
            for (UserHistoryItem adminHistory : history) {
                for (SimpleLinkSection adminSection : section) {
                    List<SimpleLink> item = this.defaultSimpleLinkManager.getLinksForSection("system.admin/" + adminSection.getId(), user, helper);
                    if (item.isEmpty()) continue;
                    for (SimpleLink adminItem : item) {
                        String id = adminItem.getId();
                        String label = adminItem.getLabel();
                        String title = adminItem.getTitle();
                        String url = adminItem.getUrl();
                        String linkId = adminHistory.getEntityId();
                        String linkUrl = adminHistory.getData();
                        if (linkId == null || !linkId.equals(id) || !linkUrl.endsWith(url)) continue;
                        linkIdMap.put(id, (SimpleLink)new SimpleLinkImpl(id, label, title, null, "admin-item-link", null, url, null));
                    }
                }
            }
            this.removeAdminTasks(linkIdMap, moduleIdList);
        }
        return this.limitListSize(linkIdMap);
    }

    private List<SimpleLink> limitListSize(Map<String, SimpleLink> linkIdMap) {
        int maxItems = 5;
        try {
            maxItems = Integer.parseInt(this.applicationProperties.getDefaultBackedString("jira.max.AdminPage.history.items"));
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Incorrect format of property 'jira.max.history.dropdown.items'.  Should be a number.");
        }
        ArrayList<SimpleLink> returnList = new ArrayList<SimpleLink>(linkIdMap.values());
        if (returnList.size() > maxItems) {
            returnList.subList(maxItems, returnList.size()).clear();
        }
        return returnList;
    }

    private void removeAdminTasks(Map<String, SimpleLink> linkIdMap, List<String> moduleIdList) {
        Plugin selectedPlugin = this.pluginAccessor.getPlugin("jira.top.navigation.bar");
        if (this.pluginAccessor.isPluginEnabled(selectedPlugin.getKey())) {
            Collection moduleDescriptors = selectedPlugin.getModuleDescriptors();
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                if (!this.pluginAccessor.isPluginModuleEnabled(moduleDescriptor.getCompleteKey()) || !(moduleDescriptor instanceof WebItemModuleDescriptor)) continue;
                moduleIdList.add(((WebItemModuleDescriptor)moduleDescriptor).getLink().getId());
            }
            linkIdMap.keySet().removeAll(moduleIdList);
        }
    }
}

