/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.action.issue.AbstractIssueAction;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractIssueUpdateAction
extends AbstractIssueAction {
    private GenericValue originalIssue;
    private final IssueUpdater issueUpdater;

    public AbstractIssueUpdateAction(IssueUpdater issueUpdater) {
        this.issueUpdater = issueUpdater;
    }

    protected AbstractIssueUpdateAction() {
        this(null);
    }

    protected void doUpdate(Long eventTypeId, Comment comment) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(this.getIssue(), this.originalIssue, eventTypeId, this.getLoggedInUser());
        issueUpdateBean.setComment(comment);
        if (this.isDispatchEvent()) {
            issueUpdateBean.setDispatchEvent(true);
        }
        this.issueUpdater.doUpdate(issueUpdateBean, true);
    }

    protected void doUpdate(Long eventTypeId, Comment comment, Map params) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(this.getIssue(), this.originalIssue, eventTypeId, this.getLoggedInUser());
        issueUpdateBean.setComment(comment);
        issueUpdateBean.setParams(params);
        if (this.isDispatchEvent()) {
            issueUpdateBean.setDispatchEvent(true);
        }
        this.issueUpdater.doUpdate(issueUpdateBean, true);
    }

    protected void doUpdate(IssueUpdateBean issueUpdateBean, boolean generateChangeItems) {
        this.issueUpdater.doUpdate(issueUpdateBean, generateChangeItems);
    }

    protected void doUpdateWithChangelog(Long eventTypeId, List changeItems) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(this.getIssue(), this.originalIssue, eventTypeId, this.getLoggedInUser());
        issueUpdateBean.setChangeItems((Collection)changeItems);
        if (this.isDispatchEvent()) {
            issueUpdateBean.setDispatchEvent(true);
        }
        this.issueUpdater.doUpdate(issueUpdateBean, true);
    }

    protected void doUpdate(Long eventTypeId, IssueChangeHolder issueChangeHolder, boolean generateChangeItems, boolean sendMail) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(this.getIssue(), this.getOriginalIssue(), eventTypeId, this.getLoggedInUser(), sendMail, issueChangeHolder.isSubtasksUpdated());
        issueUpdateBean.setComment(issueChangeHolder.getComment());
        issueUpdateBean.setChangeItems((Collection)issueChangeHolder.getChangeItems());
        issueUpdateBean.setDispatchEvent(this.isDispatchEvent());
        issueUpdateBean.setParams(EasyMap.build((Object)"eventsource", (Object)"action"));
        this.issueUpdater.doUpdate(issueUpdateBean, generateChangeItems);
    }

    @Override
    public void setIssue(GenericValue issue) {
        if (this.originalIssue == null) {
            this.originalIssue = ComponentAccessor.getIssueManager().getIssue(issue.getLong("id"));
        }
        super.setIssue(issue);
    }

    protected GenericValue getOriginalIssue() {
        return this.originalIssue;
    }
}

