/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.jira.JiraApplicationContext;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;

public class DefaultJiraApplicationContext
implements JiraApplicationContext {
    private final ApplicationProperties applicationProperties;
    private final JiraLicenseService jiraLicenseService;
    private String temporaryServerId = null;

    public DefaultJiraApplicationContext(ApplicationProperties applicationProperties, JiraLicenseService jiraLicenseService) {
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.jiraLicenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
    }

    public String getFingerPrint() {
        String serverId = this.getServerId();
        serverId = serverId != null ? serverId : this.getTemporaryServerId();
        String baseUrl = this.getBaseUrl();
        return this.generateFingerPrint(serverId, baseUrl);
    }

    String generateFingerPrint(String serverId, String baseUrl) {
        String hash = DigestUtils.md5Hex((String)(serverId + baseUrl));
        return hash == null ? "" : hash;
    }

    String getTemporaryServerId() {
        if (this.temporaryServerId == null) {
            Random random = new Random();
            this.temporaryServerId = Long.toString(random.nextLong());
        }
        return this.temporaryServerId;
    }

    String getServerId() {
        return this.jiraLicenseService.getServerId();
    }

    String getBaseUrl() {
        ApplicationProperties ap = this.getApplicationProperties();
        return ap.getString("jira.baseurl");
    }

    ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }
}

