/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;

public abstract class AbstractSimpleI18NBean {
    protected String id;
    private JiraAuthenticationContext authenticationContext;
    protected String name;
    protected String nameKey;
    protected String description;
    protected String descriptionKey;

    public AbstractSimpleI18NBean(String id, String name, String description, String nameKey, String descriptionKey) {
        this.init(id, name, description, nameKey, descriptionKey, null);
    }

    public AbstractSimpleI18NBean(String id, String name, String description, String nameKey, String descriptionKey, JiraAuthenticationContext authenticationContext) {
        this.init(id, name, description, nameKey, descriptionKey, authenticationContext);
    }

    private void init(String id, String name, String description, String nameKey, String descriptionKey, JiraAuthenticationContext authenticationContext) {
        this.descriptionKey = descriptionKey;
        this.nameKey = nameKey;
        this.description = description;
        this.name = name;
        this.id = id;
        this.authenticationContext = authenticationContext;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.nameKey != null) {
            return this.getText(this.nameKey);
        }
        return this.name;
    }

    public String getDescription() {
        if (this.descriptionKey != null) {
            return this.getText(this.descriptionKey);
        }
        return this.description;
    }

    protected String getText(String key) {
        return this.getAuthenticationContext().getI18nHelper().getText(key);
    }

    private JiraAuthenticationContext getAuthenticationContext() {
        if (this.authenticationContext == null) {
            this.authenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        }
        return this.authenticationContext;
    }
}

