/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.baseurl;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.baseurl.BaseUrl;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class IncludeResourcesFilter
extends AbstractHttpFilter {
    private final JiraWebResourceManager webResourceManager;
    private final BaseUrl baseUrl;

    @Autowired
    public IncludeResourcesFilter(@ComponentImport JiraWebResourceManager webResourceManager, BaseUrl baseUrl) {
        this.webResourceManager = webResourceManager;
        this.baseUrl = baseUrl;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.webResourceManager.putMetadata("server-scheme", String.valueOf(request.getScheme()));
        this.webResourceManager.putMetadata("server-port", String.valueOf(request.getServerPort()));
        this.webResourceManager.putMetadata("server-name", String.valueOf(request.getServerName()));
        this.webResourceManager.putMetadata("behind-proxy", String.valueOf(request.getHeader("Http-X-Forwarded-For")));
        this.webResourceManager.putMetadata("base-url", this.baseUrl.asString());
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

