(function ($) {

    "use strict";

    var $banner,

        BaseUrl = {
            jiraRestPath: contextPath + "/rest/api/2/settings/baseUrl",
            baseUrlRestPath: contextPath + "/rest/baseurl/1/",

            hideBannerHandler: function () {
                JIRA.SmartAjax.makeRequest({
                    url: BaseUrl.baseUrlRestPath,
                    type: "POST"
                });
                BaseUrl.destroyBanner();
            },

            createBanner: function () {
                var requestUrl = BaseUrl.constructRequestUrl(parseUri(location));
                $banner = $(JIRA.Templates.baseUrlMessage({
                    baseUrl: AJS.Meta.get("base-url"),
                    requestUrl: requestUrl
                }));
                $banner.find("#baseurl-update").click(function (e) {
                    e.preventDefault();
                    BaseUrl.updateBaseUrl(requestUrl);
                });
                $banner.find("#baseurl-dismiss").click(function (e) {
                    e.preventDefault();
                    BaseUrl.hideBannerHandler();
                });
                $(function () {
                    $banner.prependTo('#header');
                });
            },

            destroyBanner: function () {
                $banner.slideUp(function () {
                    $banner.remove();
                });
            },

            constructRequestUrl: function (request) {
                return request.protocol + "://" + request.authority + contextPath;
            },

            updateBaseUrl: function (baseUrl) {
                JIRA.SmartAjax.makeRequest({
                    url: BaseUrl.jiraRestPath,
                    type: "PUT",
                    data: baseUrl,
                    contentType: "application/json"
                }).done(function () {
                    JIRA.Messages.showSuccessMsg(AJS.I18n.getText("update.baseurl.success", "<a href='" + baseUrl + "'>" + baseUrl + "</a>"));
                });
                BaseUrl.destroyBanner();
            }
        };

    if (!$('#base-url-banner').length) {
        BaseUrl.createBanner();
    }

}(AJS.$));
