/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.baseurl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserPropertyManager;
import com.opensymphony.module.propertyset.PropertySet;

public class BannerPreferences {
    private static final String HIDE_BANNER = BannerPreferences.class.getName();
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserPropertyManager userPropertyManager;
    private final PermissionManager permissionManager;

    public BannerPreferences(JiraAuthenticationContext jiraAuthenticationContext, UserPropertyManager userPropertyManager, PermissionManager permissionManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userPropertyManager = userPropertyManager;
        this.permissionManager = permissionManager;
    }

    public boolean getShowBanner() {
        User user = this.getUser();
        return user != null && this.permissionManager.hasPermission(0, user) && !this.getPropertySet(user).getBoolean(HIDE_BANNER);
    }

    public void setHideBanner() {
        User user = this.getUser();
        if (user != null) {
            this.getPropertySet(user).setBoolean(HIDE_BANNER, true);
        }
    }

    private PropertySet getPropertySet(User user) {
        return user != null ? this.userPropertyManager.getPropertySet(user) : null;
    }

    private User getUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }
}

