package com.atlassian.query;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.user.ApplicationUser;

@ExperimentalApi
public interface PersonalDataInQueryFindingService {

    /**
     * Test the given query to find out whether it contains any
     * references to the given user. See {@link UserDataInQuery} for
     * description of all possible return values
     *
     * @param user the given user
     * @param query the given query
     */
    UserDataInQuery containsUserData(ApplicationUser user, Query query);

    enum UserDataInQuery {
        /**
         * The query contains at least one reference to the user.
         */
        YES,

        /**
         * The query might contain possible references, but the match
         * is not 100% certain. This could due to two reasons:
         * <ul>
         *     <li>user identifier in the query matches multiple users,</li>
         *
         *     <li>user identifier occurs is such a place where it's
         *     impossible to verify if it's a real user reference.</li>
         * </ul>
         */
        MAYBE,

        /**
         * The query contains no references to the user.
         */
        NO
    }
}
