package com.atlassian.jira.web;

import com.atlassian.webresource.api.assembler.resource.ResourcePhase;

import javax.annotation.Nonnull;

public interface RequestAssetPhaseStore {
    /**
     * @return information about the default resource phase that should be used for the resource
     * URLs returned to the clients.
     * @see ResourcePhase
     */
    @Nonnull
    ResourcePhase getPhase();

    /**
     * The default phase for the returned resource URLs will be {@link ResourcePhase#DEFER}
     */
    void useDeferPhase();
}
