package com.atlassian.jira.security.xsrf;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;

/**
 * The result of the XSRF checks
 */
@PublicApi
public interface XsrfCheckResult {
    /**
     * @return true if the invocation check was required to be performed
     */
    boolean isRequired();

    /**
     * @return true if the invocation check passed
     * Note: Referer and Origin headers are not taken into account
     */
    boolean isValid();

    /**
     * @return true if there was an authenticated user in the original request
     */
    boolean isGeneratedForAuthenticatedUser();

    /**
     * @return true if Origin or Referer header points to the same domain the Jira server lives
     * or match known browser extension.
     * The behavior may change in future to take CORS into account.
     */
    @Internal
    boolean isOriginAllowed();

    /**
     * @return true if an XSRF token was provided in the original request
     */
    boolean isTokenPresent();
}
