package com.atlassian.jira.security.xsrf;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The annotation used to indicate that a method (or a whole class) does NOT need XSRF protection checking
 *
 * @since v9.0
 */
@Retention(value = RetentionPolicy.RUNTIME)
@Target(value = {ElementType.METHOD, ElementType.TYPE})
public @interface DoesNotRequireXsrfCheck {
}
