package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.webfragment.JiraWebInterfaceManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;

import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Convenient abstraction for jira specific {@link Condition}'s.
 *
 * @deprecated Extend {@link AbstractWebCondition} instead. Since v6.0.
 */
@Deprecated
@PublicSpi
public abstract class AbstractJiraCondition implements Condition {
    public void init(Map params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map context) {
        final JiraHelper jiraHelper = (JiraHelper) context.get(JiraWebInterfaceManager.CONTEXT_KEY_HELPER);
        final ApplicationUser appUser = getApplicationUser(context);

        return SafePluginPointAccess.call(new Callable<Boolean>() {
            @Override
            public Boolean call() throws Exception {
                return shouldDisplay(appUser, jiraHelper);
            }
        }).getOrElse(false);
    }

    private ApplicationUser getApplicationUser(final Map context) {
        ApplicationUser appUser = (ApplicationUser) context.get(JiraWebInterfaceManager.CONTEXT_KEY_USER);
        if (appUser == null) {
            // cross product plugins may not have access to the user object jira uses and will only be able to put the
            // username into the context.  Need to do a lookup here.
            final String username = (String) context.get(JiraWebInterfaceManager.CONTEXT_KEY_USERNAME);
            appUser = getUserManager().getUserByName(username);
        }
        return appUser;
    }

    @VisibleForTesting
    UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }

    public abstract boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper);
}
